/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

public class WebCompJndiBinder {
    private Logger log = Logger.getLogger(this.getClass());
    private BootstrapBean bootstrapBean;
    private String deploymentUnitName;
    private Context context;

    public WebCompJndiBinder(BootstrapBean bootstrapBean, String deploymentUnitName) {
        this.deploymentUnitName = deploymentUnitName;
        if (bootstrapBean == null) {
            throw new RuntimeException("Bootstrap bean cannot be null");
        }
        this.bootstrapBean = bootstrapBean;
    }

    public void bindToJavaComp() {
        try {
            this.context = (Context)new InitialContext().lookup("java:comp/");
            this.context.bind("BeanManager", (Object)this.bootstrapBean.getBootstrap().getManager(this.bootstrapBean.getDeployment().getFlatBeanDeploymentArchive()));
        }
        catch (NamingException e) {
            this.log.error((Object)("No java:comp context found for " + this.deploymentUnitName));
        }
    }

    public void unbind() {
        try {
            this.context.unbind("BeanManager");
        }
        catch (NamingException e) {
            this.log.error((Object)"Cound not unbind java:comp/BeanManager");
        }
    }
}

