package org.jboss.weld.integration.deployer.jndi;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;

import org.jboss.logging.Logger;

/**
 * @author Marius Bogoevici
 */
public abstract class JavaCompJndiBinder
{
   protected Logger log = Logger.getLogger(getClass());
   private String deploymentUnitName;

   public JavaCompJndiBinder(String deploymentUnitName)
   {
      this.deploymentUnitName = deploymentUnitName;
   }

   public void bindToJavaComp()
   {
      try
      {
         getJavaCompContext().bind("BeanManager",new Reference(BeanManager.class.getName(), "org.jboss.weld.resources.ManagerObjectFactory", null));      
      }
      catch (NamingException e)
      {
         log.error("Could not bound BeanManager on " + getJavaContextDescription());
      }
   }

   protected abstract Context getJavaCompContext() throws NamingException;

   protected abstract String getJavaContextDescription();

   public void unbind()
   {
      try
      {
         getJavaCompContext().unbind("BeanManager");
      }
      catch (NamingException e)
      {
         log.error("Cound not unbind java:comp/BeanManager for " + deploymentUnitName);
      }
   }
}
