package org.jboss.weld.integration.deployer.jndi;

import static org.jboss.reloaded.naming.deployers.util.AnnotationHelper.annotation;

import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.plugins.graph.Search;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.javaee.JavaEEModuleInformer;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.plugins.scope.ApplicationScope;
import org.jboss.metadata.plugins.scope.DeploymentScope;
import org.jboss.metadata.plugins.scope.InstanceScope;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

/**
 * @author Marius Bogoevici
 */
public class JavaEEComponentJndiBinderDeployer extends AbstractSimpleRealDeployer<JBossEnterpriseBeanMetaData>
{

   private JavaEEComponentInformer informer;

   public JavaEEComponentJndiBinderDeployer(JavaEEComponentInformer javaEEComponentInformer)
   {
      super(JBossEnterpriseBeanMetaData.class);
      informer = javaEEComponentInformer;
      setComponentsOnly(true);
      setOutput(BeanMetaData.class);
   }

   @Override
   public void deploy(DeploymentUnit deploymentUnit, JBossEnterpriseBeanMetaData jBossEnterpriseBeanMetaData) throws DeploymentException
   {
      BeanMetaData bbBMD = getBootstrapBeanAttachment(deploymentUnit.getTopLevel());
      if (bbBMD == null)
      {
         return;
      }

      if (informer.getModuleType(deploymentUnit).equals(org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer.ModuleType.EJB))
      {
         BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder(deploymentUnit.getName() + "_CompJndiBinder", JavaEEComponentJndiBinder.class.getName());
         AbstractInjectionValueMetaData javaComponent = new AbstractInjectionValueMetaData(getComponentBeanName(deploymentUnit));
         builder.addConstructorParameter(JavaEEComponent.class.getName(), javaComponent);
         builder.addConstructorParameter(String.class.getName(), deploymentUnit.getName());
         builder.addInstall("bindToJavaComp");
         deploymentUnit.getParent().addAttachment(deploymentUnit.getName() + "_JavaCompBinder", builder.getBeanMetaData());
      }
   }

   private BeanMetaData getBootstrapBeanAttachment(DeploymentUnit deploymentUnit)
   {
      String bootstrapName = DeployersUtils.getBootstrapBeanName(deploymentUnit.getTopLevel());
      String bbAttachmentName = bootstrapName + "_" + BeanMetaData.class.getSimpleName();

      BeanMetaData bbBMD = deploymentUnit.getTopLevel().getAttachment(bbAttachmentName, BeanMetaData.class);
      return bbBMD;
   }

   private String getComponentBeanName(DeploymentUnit deploymentUnit)
   {
      String appName = informer.getApplicationName(deploymentUnit);
      String moduleName = informer.getModulePath(deploymentUnit);
      String componentName = informer.getComponentName(deploymentUnit);
      String name = "jboss.naming:";
      if(appName != null)
         name += "application=" + appName + ",";
      name += "module=" + moduleName + ",component=" + componentName;
      return name;
   }

}
