package org.jboss.weld.integration.deployer.jndi;

import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.reloaded.naming.spi.JavaEEModule;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

/**
 * @author Marius Bogoevici
 */
public class WebJndiBinderDeployer extends AbstractSimpleRealDeployer<JBossWebMetaData>
{

   private JavaEEModuleInformer informer;

   public WebJndiBinderDeployer(JavaEEModuleInformer javaEEModuleInformer)
   {
      super(JBossWebMetaData.class);
      informer = javaEEModuleInformer;
      setOutput(BeanMetaData.class);
   }

   @Override
   public void deploy(DeploymentUnit deploymentUnit, JBossWebMetaData jBossWebMetaData) throws DeploymentException
   {
      BeanMetaData bbBMD = getBootstrapBeanAttachment(deploymentUnit.getTopLevel());
      if (bbBMD != null && informer.getModuleType(deploymentUnit).equals(JavaEEModuleInformer.ModuleType.WEB))
      {
         BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder(deploymentUnit.getName() + "_WebCompJndiBinder", SimpleCompJndiBinder.class.getName());
         builder.addConstructorParameter(String.class.getName(), deploymentUnit.getName());
         builder.addInstall("bindToJavaComp");
         builder.addUninstall("unbind");
         deploymentUnit.getTopLevel().addAttachment(deploymentUnit.getName() + "_WebCompJndiBinder", builder.getBeanMetaData());

         BeanMetaDataBuilder moduleBinderBuilder = BeanMetaDataBuilder.createBuilder(deploymentUnit.getName() + "_JavaModuleJndiBinder", JavaEEModuleJndiBinder.class.getName());
         AbstractInjectionValueMetaData javaModule = new AbstractInjectionValueMetaData(getModuleBeanName(deploymentUnit));
         moduleBinderBuilder.addConstructorParameter(JavaEEModule.class.getName(), javaModule);
         moduleBinderBuilder.addConstructorParameter(String.class.getName(), deploymentUnit.getName());
         moduleBinderBuilder.addInstall("bindToJavaComp");
         moduleBinderBuilder.addUninstall("unbind");
         deploymentUnit.getTopLevel().addAttachment(deploymentUnit.getName() + "_JavaModuleJndiBinder", moduleBinderBuilder.getBeanMetaData());
      }
   }

   private BeanMetaData getBootstrapBeanAttachment(DeploymentUnit deploymentUnit)
   {
      String bootstrapName = DeployersUtils.getBootstrapBeanName(deploymentUnit.getTopLevel());
      String bbAttachmentName = bootstrapName + "_" + BeanMetaData.class.getSimpleName();

      BeanMetaData bbBMD = deploymentUnit.getTopLevel().getAttachment(bbAttachmentName, BeanMetaData.class);
      return bbBMD;
   }

   private String getModuleBeanName(DeploymentUnit deploymentUnit)
   {
      String appName = informer.getApplicationName(deploymentUnit);
      String moduleName = informer.getModulePath(deploymentUnit);
      String name = "jboss.naming:";
      if (appName != null)
      {
         name += "application=" + appName + ",";
      }
      name += "module=" + moduleName;
      return name;
   }


}