/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.weld.osgi.tests.cdispi;


import javax.inject.Inject;
import org.jboss.weld.environment.osgi.api.annotation.OSGiService;
import org.jboss.weld.environment.osgi.api.annotation.Publish;
import org.jboss.weld.osgi.tests.bundle1.api.Name;
import org.jboss.weld.osgi.tests.bundle1.api.PropertyService;

@Publish
public class ServiceExtensionProvider {

    @Inject
    @Name("extension")
    private PropertyService serviceExtension;

    @Inject
    @OSGiService
    @Name("extension")
    private PropertyService serviceExtensionService;

    public PropertyService getServiceExtension() {
        return serviceExtension;
    }

    public PropertyService getServiceExtensionService() {
        return serviceExtensionService;
    }
}
