/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.util.Preconditions;

public class BeanArchiveBuilder {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Set<String> beanClasses = new HashSet<String>();
    private BeansXml beansXml;
    private String id;
    private Set<String> knownClasses;

    public WeldBeanDeploymentArchive build() {
        Preconditions.checkArgumentNotNull(this.id, "id");
        return new WeldBeanDeploymentArchive(this.id, this.beanClasses, this.knownClasses, this.getBeansXml());
    }

    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public BeanArchiveBuilder setBeansXml(BeansXml beansXml) {
        this.beansXml = beansXml;
        if (beansXml != null && BeanDiscoveryMode.ANNOTATED.equals((Object)beansXml.getBeanDiscoveryMode())) {
            this.knownClasses = new HashSet<String>(this.beanClasses);
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public BeanArchiveBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public BeanArchiveBuilder addClass(String className) {
        this.beanClasses.add(className);
        return this;
    }

    public BeanArchiveBuilder clearClasses() {
        this.beanClasses.clear();
        return this;
    }

    public Set<String> getClasses() {
        return this.beanClasses;
    }

    public BeanArchiveBuilder setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Iterator<String> getClassIterator() {
        return this.beanClasses.iterator();
    }
}

