/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LogMessageCallback;
import org.jboss.weld.logging.MessageCallback;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface ValidatorLogger
extends WeldLogger {
    public static final ValidatorLogger LOG = Logger.getMessageLogger(ValidatorLogger.class, Category.VALIDATOR.getName());
    public static final MessageCallback<DefinitionException> INJECTION_INTO_DISPOSER_METHOD = t -> LOG.injectionIntoDisposerMethod(t[0], t[1]);
    public static final MessageCallback<DefinitionException> INJECTION_INTO_NON_BEAN = t -> LOG.injectionIntoNonBean(t[0], t[1]);
    public static final MessageCallback<DeploymentException> INTERCEPTOR_SPECIFIED_TWICE = t -> LOG.interceptorSpecifiedTwice(t[0], t[1], t[2]);
    public static final MessageCallback<DeploymentException> DECORATOR_SPECIFIED_TWICE = t -> LOG.decoratorSpecifiedTwice(t[0], t[1], t[2]);
    public static final MessageCallback<DeploymentException> ALTERNATIVE_CLASS_SPECIFIED_MULTIPLE_TIMES = t -> LOG.alternativeClassSpecifiedMultipleTimes(t[0], t[1], t[2]);
    public static final MessageCallback<DeploymentException> ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES = t -> LOG.alternativeStereotypeSpecifiedMultipleTimes(t[0], t[1], t[2]);
    public static final LogMessageCallback INTERCEPTOR_ENABLED_FOR_APP_AND_ARCHIVE = t -> LOG.interceptorEnabledForApplicationAndBeanArchive(t[0], t[1]);
    public static final LogMessageCallback DECORATOR_ENABLED_FOR_APP_AND_ARCHIVE = t -> LOG.decoratorEnabledForApplicationAndBeanArchive(t[0], t[1]);

    @Message(id=1401, value="Two beans cannot specialize the same bean {0}", format=Message.Format.MESSAGE_FORMAT)
    public InconsistentSpecializationException beanSpecializedTooManyTimes(Object var1);

    @Message(id=1402, value="The bean {0} declares a passivating scope but has a non-serializable interceptor {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException passivatingBeanWithNonserializableInterceptor(Object var1, Object var2);

    @Message(id=1403, value="The bean {0} declares a passivating scope but has a non-serializable decorator {1}", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException passivatingBeanWithNonserializableDecorator(Object var1, Object var2);

    @Message(id=1404, value="The injection point is annotated with @New which cannot be combined with other qualifiers: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException newWithQualifiers(Object var1, Object var2);

    @Message(id=1405, value="Cannot inject {0} in a class which is not a bean\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionIntoNonBean(Object var1, Object var2);

    @Message(id=1406, value="Cannot inject injection point metadata in a non @Dependent scoped bean: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionIntoNonDependentBean(Object var1, Object var2);

    @Message(id=1407, value="Cannot declare an injection point with a type variable: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionPointWithTypeVariable(Object var1, Object var2);

    @Message(id=1408, value="Unsatisfied dependencies for type {2} with qualifiers {1}\n  at injection point {0}\n  at {3}\n{4}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException injectionPointHasUnsatisfiedDependencies(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1409, value="Ambiguous dependencies for type {2} with qualifiers {1}\n  at injection point {0}\n  at {3}\n  Possible dependencies: {4}\n", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException injectionPointHasAmbiguousDependencies(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1410, value="The injection point has non-proxyable dependencies: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException injectionPointHasNonProxyableDependencies(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=1413, value="The bean {0} declares a passivating scope but has a non-passivation-capable dependency {1}", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException injectionPointHasNonSerializableDependency(Object var1, Object var2);

    @Message(id=1414, value="Bean name is ambiguous. Name {0} resolves to beans: {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException ambiguousElName(Object var1, Object var2);

    @Message(id=1415, value="Bean name is identical to a bean name prefix used elsewhere. Name {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException beanNameIsPrefix(Object var1);

    @Message(id=1416, value="Enabled interceptor class {0} specified twice:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException interceptorSpecifiedTwice(Object var1, Object var2, Object var3);

    @Message(id=1417, value="Enabled interceptor class {0} ({1}) does not match an interceptor bean: the class is not found, or not annotated with @Interceptor and still not registered through a portable extension, or not annotated with @Dependent inside an implicit bean archive", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException interceptorClassDoesNotMatchInterceptorBean(Object var1, Object var2);

    @Message(id=1418, value="Enabled decorator class {0} specified twice:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException decoratorSpecifiedTwice(Object var1, Object var2, Object var3);

    @Message(id=1419, value="Enabled decorator class {0} is not the bean class of at least one decorator bean (detected decorator beans: {1})", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException decoratorClassNotBeanClassOfDecorator(Object var1, Object var2);

    @Message(id=1420, value="Enabled alternative {0} is not a stereotype", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeStereotypeNotStereotype(Object var1);

    @Message(id=1421, value="Cannot enable the same alternative stereotype {0} in beans.xml:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeStereotypeSpecifiedMultipleTimes(Object var1, Object var2, Object var3);

    @Message(id=1422, value="Enabled alternative class {0} ({1}) does not match any bean, or is not annotated with @Alternative or an @Alternative stereotype, or does not declare a producer annotated with @Alternative or an @Alternative stereotype", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeBeanClassNotAnnotated(Object var1, Object var2);

    @Message(id=1424, value="The following disposal methods were declared but did not resolve to a producer method: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException disposalMethodsWithoutProducer(Object var1);

    @Message(id=1425, value="An injection point cannot have a wildcard type parameter: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionPointHasWildcard(Object var1, Object var2);

    @Message(id=1426, value="An injection point must have a type parameter: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionPointMustHaveTypeParameter(Object var1, Object var2);

    @Message(id=1427, value="Only field injection points can use the @Named qualifier with no value: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException nonFieldInjectionPointCannotUseNamed(Object var1, Object var2);

    @Message(id=1428, value="A decorator cannot have producer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveProducerMethods(Object var1);

    @Message(id=1429, value="A decorator cannot have producer fields, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveProducerFields(Object var1);

    @Message(id=1430, value="A decorator cannot have disposer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveDisposerMethods(Object var1);

    @Message(id=1431, value="An interceptor cannot have producer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveProducerMethods(Object var1);

    @Message(id=1432, value="An interceptor cannot have producer fields, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveProducerFields(Object var1);

    @Message(id=1433, value="An interceptor cannot have disposer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveDisposerMethods(Object var1);

    @Message(id=1434, value="Normal scoped bean {0} is not proxyable for an unknown reason - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableUnknown(Object var1, Object var2);

    @Message(id=1435, value="Normal scoped bean {0} is not proxyable because it has no no-args constructor - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableNoConstructor(Object var1, Object var2);

    @Message(id=1436, value="Type {0} is not proxyable because it has a private constructor {1} - {2}.", format=Message.Format.MESSAGE_FORMAT)
    public String notProxyablePrivateConstructor(Object var1, Object var2, Object var3);

    @Message(id=1437, value="Bean type {0} is not proxyable because it is final - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableFinalType(Object var1, Object var2);

    @Message(id=1438, value="Bean type {0} is not proxyable because it is a primitive - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyablePrimitive(Object var1, Object var2);

    @Message(id=1439, value="Bean type {0} is not proxyable because it is an array type - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableArrayType(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1440, value="Scope type {0} used on injection point {1}\n\tat {2}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public void scopeAnnotationOnInjectionPoint(Object var1, Object var2, Object var3);

    @Message(id=1441, value="Enabled alternative {0} is not a class", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeBeanClassNotClass(Object var1);

    @Message(id=1442, value="Enabled alternative {0} is not annotated @Alternative", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeStereotypeNotAnnotated(Object var1);

    @Message(id=1443, value="Pseudo scoped bean has circular dependencies. Dependency path: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException pseudoScopedBeanHasCircularReferences(Object var1);

    @Message(id=1445, value="An interceptor cannot have observer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveObserverMethods(Object var1);

    @Message(id=1446, value="A decorator cannot have observer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveObserverMethods(Object var1);

    @Message(id=1447, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not return {3}\n\tat {4}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotReturnObject(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1448, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have exactly one parameter\n\tat {3}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveExactlyOneParameter(Object var1, Object var2, Object var3, Object var4);

    @Message(id=1449, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but its single parameter is not a {3}\n\tat {4}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveCorrectTypeOfParameter(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1451, value="jakarta.transaction.UserTransaction cannot be injected into an enterprise bean with container-managed transactions: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException userTransactionInjectionIntoBeanWithContainerManagedTransactions(Object var1, Object var2);

    @Message(id=1452, value="{0} is not a valid type for a Bean metadata injection point {1}\n\tat {2}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidBeanMetadataInjectionPointType(Object var1, Object var2, Object var3);

    @Message(id=1453, value="{0} is not a valid type argument for a Bean metadata injection point {1}\n\tat {2}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidBeanMetadataInjectionPointTypeArgument(Object var1, Object var2, Object var3);

    @Message(id=1454, value="{0} cannot be used at a Bean metadata injection point of a bean which is not {1}, {2}\n\tat {3}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidBeanMetadataInjectionPointQualifier(Object var1, Object var2, Object var3, Object var4);

    @Message(id=1455, value="{0} does not declare any decorated types.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException noDecoratedTypes(Object var1);

    @Message(id=1456, value="Argument {0} must not be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException argumentNull(Object var1);

    @Message(id=1457, value="Cannot enable the same alternative class {0} in beans.xml:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeClassSpecifiedMultipleTimes(Object var1, Object var2, Object var3);

    @Message(id=1463, value="Bean declaring a passivating scope must be passivation capable.  Bean:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException beanWithPassivatingScopeNotPassivationCapable(Object var1);

    @Message(id=1465, value="{0} for a built-in bean {1} must be passivation capable.", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException builtinBeanWithNonserializableDecorator(Object var1, Object var2);

    @Message(id=1466, value="Invalid injection point found in a disposer method: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionIntoDisposerMethod(Object var1, Object var2);

    @Message(id=1467, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not return {3} or {4}.\n\tat {5}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotReturnObjectOrVoid(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6);

    @Message(id=1468, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have a {3} return type.\n\tat {4}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveVoidReturnType(Object var1, Object var2, Object var3, Object var4, Object var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1469, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have zero parameters.\n", format=Message.Format.MESSAGE_FORMAT)
    public void interceptorMethodDoesNotHaveZeroParameters(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1471, value="Interceptor method {0} defined on class {1} is not defined according to the specification. It should not throw {2}, which is a checked exception.\n\tat {3}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public void interceptorMethodShouldNotThrowCheckedExceptions(Object var1, Object var2, Object var3, Object var4);

    @Message(id=1472, value="EventMetadata can only be injected into an observer method: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException eventMetadataInjectedOutsideOfObserver(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1473, value="jakarta.enterprise.inject.spi.Bean implementation {0} declared a normal scope but does not implementjakarta.enterprise.inject.spi.PassivationCapable. It won'''t be possible to inject this bean into a bean with a passivating scope (@SessionScoped, @ConversationScoped). This can be fixed by assigning the Bean implementation a unique id by implementing the PassivationCapable interface.", format=Message.Format.MESSAGE_FORMAT)
    public void beanNotPassivationCapable(Object var1);

    @Message(id=1474, value="Class {0} is on the classpath, but was ignored because a class it references was not found: {1}.\n", format=Message.Format.MESSAGE_FORMAT)
    public String unsatisfiedDependencyBecauseClassIgnored(Object var1, Object var2);

    @Message(id=1475, value="The following beans match by type, but none have matching qualifiers:{0}\n", format=Message.Format.MESSAGE_FORMAT)
    public String unsatisfiedDependencyBecauseQualifiersDontMatch(Object var1);

    @Message(id=1476, value="{0} must be @Dependent", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorOrDecoratorMustBeDependent(Object var1);

    @Message(id=1477, value="The bean {0} declares a passivating scope but has a(n) {1} with a non-passivation-capable dependency {2}", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException interceptorDecoratorInjectionPointHasNonSerializableDependency(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1478, value="Interceptor {0} is enabled for the application and for the bean archive {1}. It will only be invoked in the @Priority part of the chain.", format=Message.Format.MESSAGE_FORMAT)
    public void interceptorEnabledForApplicationAndBeanArchive(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1479, value="Decorator {0} is enabled for the application and for the bean archive {1}. It will only be invoked in the @Priority part of the chain.", format=Message.Format.MESSAGE_FORMAT)
    public void decoratorEnabledForApplicationAndBeanArchive(Object var1, Object var2);

    @Message(id=1480, value="Bean type {0} is not proxyable because it contains a final method {1} - {2}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableFinalMethod(Object var1, Method var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1481, value="Final method will be ignored during proxy generation and should never be invoked upon the proxy instance! {0} - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public void notProxyableFinalMethodIgnored(Method var1, Object var2);

    @Message(id=1482, value="InterceptionFactory can only be injected in a parameter of a producer method: {0}\n\tat {1}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidInterceptionFactoryInjectionPoint(Object var1, Object var2);

    @Message(id=1483, value="Argument must not be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException argumentNull();

    @Message(id=1485, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} and it declares more than one parameter.\n\tat {3}\n  StackTrace", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDeclaresMultipleParameters(Object var1, Object var2, Object var3, Object var4);

    @Message(id=1486, value="Instance lookup configured for target bean {0} and target method {1} is unsatisfied", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invokerUnsatisfiedInstanceLookup(Class<?> var1, Method var2);

    @Message(id=1487, value="Instance lookup configured for target bean {0} and target method {1} is ambiguous", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invokerAmbiguousInstanceLookup(Class<?> var1, Method var2);

    @Message(id=1488, value="Argument lookup configured for target bean {0} and parameter {2} of target method {1} is unsatisfied", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invokerUnsatisfiedArgumentLookup(Class<?> var1, Method var2, int var3);

    @Message(id=1489, value="Argument lookup configured for target bean {0} and parameter {2} of target method {1} is ambiguous", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invokerAmbiguousArgumentLookup(Class<?> var1, Method var2, int var3);

    @Message(id=1490, value="Bean type {0} is not proxyable because it is sealed - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableSealedType(Object var1, Object var2);
}

