package org.jboss.weld.environment.se.logging;

import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class WeldSELogger_$logger extends DelegatingBasicLogger implements WeldSELogger, WeldEnvironmentLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldSELogger_$logger.class.getName();
    public WeldSELogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String weldContainerAlreadyRunning$str() {
        return "WELD-ENV-002000: Weld SE container {0} is already running!";
    }
    @Override
    public final IllegalStateException weldContainerAlreadyRunning(final Object id) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(weldContainerAlreadyRunning$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void weldContainerShutdown(final Object id) {
        super.log.logv(FQCN, INFO, null, weldContainerShutdown$str(), id);
    }
    protected String weldContainerShutdown$str() {
        return "WELD-ENV-002001: Weld SE container {0} shut down";
    }
    protected String weldContainerAlreadyShutDown$str() {
        return "WELD-ENV-002002: Weld SE container {0} was already shut down";
    }
    @Override
    public final IllegalStateException weldContainerAlreadyShutDown(final Object id) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(weldContainerAlreadyShutDown$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void weldContainerInitialized(final Object id) {
        super.log.logv(FQCN, INFO, null, weldContainerInitialized$str(), id);
    }
    protected String weldContainerInitialized$str() {
        return "WELD-ENV-002003: Weld SE container {0} initialized";
    }
    @Override
    public final void scanningPackage(final Object packageName, final Object resource) {
        super.log.logv(FQCN, DEBUG, null, scanningPackage$str(), packageName, resource);
    }
    protected String scanningPackage$str() {
        return "WELD-ENV-002004: Scanning package {0}, class resource: {1}";
    }
    @Override
    public final void packageNotFound(final Object packageName) {
        super.log.logv(FQCN, WARN, null, packageNotFound$str(), packageName);
    }
    protected String packageNotFound$str() {
        return "WELD-ENV-002005: Package intended for scanning was not found: {0}";
    }
    @Override
    public final void multipleContainersRunning(final Object ids) {
        super.log.logv(FQCN, INFO, null, multipleContainersRunning$str(), ids);
    }
    protected String multipleContainersRunning$str() {
        return "WELD-ENV-002006: Multiple containers running - CDI.current() may not work properly: {0}";
    }
    @Override
    public final void resourceUrlProtocolNotSupported(final Object resource) {
        super.log.logv(FQCN, DEBUG, null, resourceUrlProtocolNotSupported$str(), resource);
    }
    protected String resourceUrlProtocolNotSupported$str() {
        return "WELD-ENV-002007: Resource URL procotol not supported: {0}";
    }
    @Override
    public final void beanClassDeployedInMultipleBeanArchives(final Object beanClass, final Object bdas) {
        super.log.logv(FQCN, WARN, null, beanClassDeployedInMultipleBeanArchives$str(), beanClass, bdas);
    }
    protected String beanClassDeployedInMultipleBeanArchives$str() {
        return "WELD-ENV-002008: Bean class {0} found in multiple bean archives - this may result in incorrect behavior: {1}";
    }
    protected String weldContainerCannotBeInitializedNoBeanArchivesFound$str() {
        return "WELD-ENV-002009: Weld SE container cannot be initialized - no bean archives found";
    }
    @Override
    public final IllegalStateException weldContainerCannotBeInitializedNoBeanArchivesFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), weldContainerCannotBeInitializedNoBeanArchivesFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String observedTypeNotContonainerLifecycleEventType$str() {
        return "WELD-ENV-002010: The observed type {0} is not a container lifecycle event type";
    }
    @Override
    public final IllegalArgumentException observedTypeNotContonainerLifecycleEventType(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(observedTypeNotContonainerLifecycleEventType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String observedTypeDoesNotMatchContonainerLifecycleEventType$str() {
        return "WELD-ENV-002011: The observed type {0} does not match the container lifecycle event type {1}";
    }
    @Override
    public final IllegalArgumentException observedTypeDoesNotMatchContonainerLifecycleEventType(final Object type, final Object eventType) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(observedTypeDoesNotMatchContonainerLifecycleEventType$str(), type, eventType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String containerLifecycleObserverNotInitialized$str() {
        return "WELD-ENV-002012: The container lifecycle observer is not properly initialized: {0}";
    }
    @Override
    public final IllegalStateException containerLifecycleObserverNotInitialized(final Object info) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(containerLifecycleObserverNotInitialized$str(), info));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String weldContainerDeploymentNotValidated$str() {
        return "WELD-ENV-002014: Weld SE container with id {0} has not yet validated the deployment - methods for programmatic lookup cannot be used";
    }
    @Override
    public final IllegalStateException weldContainerDeploymentNotValidated(final Object id) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(weldContainerDeploymentNotValidated$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanArchiveWithModeNone$str() {
        return "WELD-ENV-002015: Bean discovery mode NONE is not a valid option for Weld SE deployment archive - Weld SE container with id {0}.";
    }
    @Override
    public final IllegalArgumentException beanArchiveWithModeNone(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(beanArchiveWithModeNone$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String zeroOrMoreThanOneContainerRunning$str() {
        return "WELD-ENV-002016: Zero or more than one container is running - WeldContainer.current() cannot determine the current container.";
    }
    @Override
    public final IllegalStateException zeroOrMoreThanOneContainerRunning() {
        final IllegalStateException result = new IllegalStateException(zeroOrMoreThanOneContainerRunning$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedValueForAdditionalBeanDefiningAnnotations$str() {
        return "WELD-ENV-002017: Unexpected value for parameter 'org.jboss.weld.se.additionalBeanDefiningAnnotations'. Expected java.util.Collection but found {0}. ";
    }
    @Override
    public final IllegalArgumentException unexpectedValueForAdditionalBeanDefiningAnnotations(final Class clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unexpectedValueForAdditionalBeanDefiningAnnotations$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unexpectedItemsInValueCollection(final Class clazz) {
        super.log.logv(FQCN, WARN, null, unexpectedItemsInValueCollection$str(), clazz);
    }
    protected String unexpectedItemsInValueCollection$str() {
        return "WELD-ENV-002018: Skipping registration of additional bean defining annotation via `org.jboss.weld.se.additionalBeanDefiningAnnotations`. Only values of type Class<? extends Annotation> are valid. Found: {0}";
    }
    protected String failedToLoadClass$str() {
        return "WELD-ENV-002019: Failed to parse the following string as additional bean defining annotation: {0}. The exception was: {1}";
    }
    @Override
    public final IllegalArgumentException failedToLoadClass(final String className, final String exception) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(failedToLoadClass$str(), className, exception));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable arg0) {
        super.log.logf(FQCN, DEBUG, arg0, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
    @Override
    public final void catchingTrace(final Throwable arg0) {
        super.log.logf(FQCN, TRACE, arg0, catchingTrace$str());
    }
    protected String catchingTrace$str() {
        return "Catching";
    }
}
