/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.FieldInfo;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.inject.spi.Bean;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bytecode.Boxing;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.ClassFileUtils;
import org.jboss.weld.util.bytecode.ConstructorUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodUtils;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory<T> {
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    public static final String PROXY_SUFFIX = "Proxy";
    public static final String DEFAULT_PROXY_PACKAGE = "org.jboss.weld.proxies";
    private final Class<?> beanType;
    private final Set<Class<?>> additionalInterfaces = new HashSet();
    private final ClassLoader classLoader;
    private final String baseProxyName;
    private static final String FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME = "firstSerializationPhaseComplete";

    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        this(proxiedBeanType, typeClosure, ProxyFactory.getProxyName(proxiedBeanType, typeClosure, bean));
    }

    /*
     * WARNING - void declaration
     */
    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName) {
        void var5_9;
        Class clazz;
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterface(c);
        }
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        Class<?> clazz2 = typeInfo.getSuperClass();
        Class clazz3 = clazz = clazz2 == null ? Object.class : clazz2;
        if (clazz.equals(Object.class)) {
            if (this.additionalInterfaces.isEmpty()) {
                Class<?> clazz4 = proxiedBeanType;
            }
            this.classLoader = Container.instance().services().get(ProxyServices.class).getClassLoader(proxiedBeanType);
        } else {
            this.classLoader = Container.instance().services().get(ProxyServices.class).getClassLoader(clazz);
        }
        this.beanType = var5_9;
        this.addDefaultAdditionalInterfaces();
        this.baseProxyName = proxyName;
    }

    private static String getProxyName(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        String proxyPackage;
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        if (proxiedBeanType.equals(Object.class)) {
            Class<?> superInterface = typeInfo.getSuperInterface();
            if (superInterface == null) {
                throw new IllegalArgumentException("Proxied bean type cannot be java.lang.Object without an interface");
            }
            proxyPackage = DEFAULT_PROXY_PACKAGE;
        } else {
            proxyPackage = proxiedBeanType.getPackage().getName();
        }
        String beanId = Container.instance().services().get(ContextualStore.class).putIfAbsent(bean);
        String className = beanId.replace('.', '$').replace(' ', '_').replace('/', '$').replace(';', '$');
        return proxyPackage + '.' + className;
    }

    public void addInterface(Class<?> newInterface) {
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException(newInterface + " is not an interface");
        }
        this.additionalInterfaces.add(newInterface);
    }

    public T create(BeanInstance beanInstance) {
        T proxy;
        block6: {
            proxy = null;
            Class<T> proxyClass = this.getProxyClass();
            try {
                if (InstantiatorFactory.useInstantiators()) {
                    proxy = SecureReflections.newUnsafeInstance(proxyClass);
                    try {
                        Field sfield = proxyClass.getDeclaredField(FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME);
                        sfield.setAccessible(true);
                        sfield.set(proxy, new ThreadLocal());
                        break block6;
                    }
                    catch (Exception e) {
                        throw new DefinitionException(BeanMessage.FAILED_TO_SET_THREAD_LOCAL_ON_PROXY, (Throwable)e, this);
                    }
                }
                proxy = SecureReflections.newInstance(proxyClass);
            }
            catch (InstantiationException e) {
                throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
            }
            catch (IllegalAccessException e) {
                throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
            }
        }
        ((ProxyObject)proxy).setHandler(new ProxyMethodHandler(beanInstance));
        return proxy;
    }

    public Class<T> getProxyClass() {
        String suffix = "_$$_Weld" + this.getProxyNameSuffix();
        String proxyClassName = this.getBaseProxyName();
        if (!proxyClassName.endsWith(suffix)) {
            proxyClassName = proxyClassName + suffix;
        }
        if (proxyClassName.startsWith("java")) {
            proxyClassName = proxyClassName.replaceFirst("java", "org.jboss.weld");
        }
        Class<Object> proxyClass = null;
        log.trace("Retrieving/generating proxy class " + proxyClassName);
        try {
            proxyClass = this.classLoader.loadClass(proxyClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                proxyClass = this.createProxyClass(proxyClassName);
            }
            catch (Exception e1) {
                throw new WeldException(e1);
            }
        }
        return proxyClass;
    }

    protected String getBaseProxyName() {
        return this.baseProxyName;
    }

    public static boolean isProxy(Object proxySuspect) {
        return proxySuspect instanceof ProxyObject;
    }

    public static <T> void setBeanInstance(T proxy, BeanInstance beanInstance) {
        if (proxy instanceof ProxyObject) {
            ProxyObject proxyView = (ProxyObject)proxy;
            proxyView.setHandler(new ProxyMethodHandler(beanInstance));
        }
    }

    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void addDefaultAdditionalInterfaces() {
        this.additionalInterfaces.add(Serializable.class);
    }

    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
    }

    private Class<T> createProxyClass(String proxyClassName) throws Exception {
        ArraySet specialInterfaces = new ArraySet(3);
        specialInterfaces.add(LifecycleMixin.class);
        specialInterfaces.add(TargetInstanceProxy.class);
        specialInterfaces.add(ProxyObject.class);
        this.addAdditionalInterfaces(specialInterfaces);
        this.additionalInterfaces.removeAll(specialInterfaces);
        ClassFile proxyClassType = null;
        if (this.beanType.isInterface()) {
            proxyClassType = new ClassFile(false, proxyClassName, Object.class.getName());
            proxyClassType.addInterface(this.beanType.getName());
        } else {
            proxyClassType = new ClassFile(false, proxyClassName, this.beanType.getName());
        }
        proxyClassType.setAccessFlags(1);
        for (Class<?> clazz : this.additionalInterfaces) {
            proxyClassType.addInterface(clazz.getName());
        }
        Bytecode initialValueBytecode = new Bytecode(proxyClassType.getConstPool());
        this.addFields(proxyClassType, initialValueBytecode);
        this.addConstructors(proxyClassType, initialValueBytecode);
        this.addMethods(proxyClassType);
        for (Class<?> specialInterface : specialInterfaces) {
            proxyClassType.addInterface(specialInterface.getName());
        }
        Class proxyClass = ClassFileUtils.toClass(proxyClassType, this.classLoader, null);
        log.trace("Created Proxy class of type " + proxyClass + " supporting interfaces " + Arrays.toString(proxyClass.getInterfaces()));
        return proxyClass;
    }

    protected void addConstructors(ClassFile proxyClassType, Bytecode initialValueBytecode) {
        try {
            if (this.beanType.isInterface()) {
                ConstructorUtils.addDefaultConstructor(proxyClassType, initialValueBytecode);
            } else {
                for (Constructor<?> constructor : this.beanType.getDeclaredConstructors()) {
                    if ((constructor.getModifiers() & 2) != 0) continue;
                    String[] exceptions = new String[constructor.getExceptionTypes().length];
                    for (int i = 0; i < exceptions.length; ++i) {
                        exceptions[i] = constructor.getExceptionTypes()[i].getName();
                    }
                    ConstructorUtils.addConstructor(DescriptorUtils.getConstructorDescriptor(constructor), exceptions, proxyClassType, initialValueBytecode);
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addFields(ClassFile proxyClassType, Bytecode initialValueBytecode) {
        try {
            proxyClassType.addField(new FieldInfo(proxyClassType.getConstPool(), "methodHandler", "Ljavassist/util/proxy/MethodHandler;"));
            FieldInfo sfield = new FieldInfo(proxyClassType.getConstPool(), FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME, "Ljava/lang/ThreadLocal;");
            sfield.setAccessFlags(130);
            proxyClassType.addField(sfield);
            initialValueBytecode.addAload(0);
            initialValueBytecode.addNew("java/lang/ThreadLocal");
            initialValueBytecode.add(89);
            initialValueBytecode.addInvokespecial("java.lang.ThreadLocal", "<init>", "()V");
            initialValueBytecode.addPutfield(proxyClassType.getName(), FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME, "Ljava/lang/ThreadLocal;");
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void addMethods(ClassFile proxyClassType) {
        this.addMethodsFromClass(proxyClassType);
        this.addSpecialMethods(proxyClassType);
        this.addSerializationSupport(proxyClassType);
    }

    protected void addSerializationSupport(ClassFile proxyClassType) {
        try {
            Class[] exceptions = new Class[]{ObjectStreamException.class};
            Bytecode writeReplaceBody = this.createWriteReplaceBody(proxyClassType);
            proxyClassType.addMethod(MethodUtils.makeMethod(1, Object.class, "writeReplace", new Class[0], exceptions, writeReplaceBody, proxyClassType.getConstPool()));
            exceptions = new Class[]{ClassNotFoundException.class, IOException.class};
            Bytecode deserializeProxyBody = this.createDeserializeProxyBody(proxyClassType);
            proxyClassType.addMethod(MethodUtils.makeMethod(9, Object.class, "deserializeProxy", new Class[]{ObjectInputStream.class}, exceptions, deserializeProxyBody, proxyClassType.getConstPool()));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private Bytecode createDeserializeProxyBody(ClassFile file) {
        Bytecode b = new Bytecode(file.getConstPool(), 3, 2);
        b.addAload(0);
        b.addInvokevirtual("java.io.ObjectInputStream", "readObject", "()Ljava/lang/Object;");
        b.add(89);
        b.addCheckcast(file.getName());
        b.addNew("java/lang/ThreadLocal");
        b.add(89);
        b.addInvokespecial("java.lang.ThreadLocal", "<init>", "()V");
        b.addPutfield(file.getName(), FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME, "Ljava/lang/ThreadLocal;");
        b.addOpcode(176);
        return b;
    }

    private Bytecode createWriteReplaceBody(ClassFile proxyClassType) {
        Bytecode runSecondPhase = new Bytecode(proxyClassType.getConstPool());
        runSecondPhase.add(42);
        runSecondPhase.addGetfield(proxyClassType.getName(), FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME, "Ljava/lang/ThreadLocal;");
        runSecondPhase.addInvokevirtual("java.lang.ThreadLocal", "remove", "()V");
        runSecondPhase.add(42);
        runSecondPhase.add(176);
        byte[] runSecondBytes = runSecondPhase.get();
        Bytecode b = new Bytecode(proxyClassType.getConstPool());
        b.add(42);
        b.addGetfield(proxyClassType.getName(), FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME, "Ljava/lang/ThreadLocal;");
        b.addInvokevirtual("java.lang.ThreadLocal", "get", "()Ljava/lang/Object;");
        b.add(198);
        BytecodeUtils.add16bit(b, runSecondBytes.length + 3);
        for (int i = 0; i < runSecondBytes.length; ++i) {
            b.add(runSecondBytes[i]);
        }
        b.add(42);
        b.addGetfield(proxyClassType.getName(), FIRST_SERIALIZATION_PHASE_COMPLETE_FIELD_NAME, "Ljava/lang/ThreadLocal;");
        b.addGetstatic("java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        b.addInvokevirtual("java.lang.ThreadLocal", "set", "(Ljava/lang/Object;)V");
        b.add(42);
        b.addGetfield(proxyClassType.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(42);
        ProxyFactory.getDeclaredMethod(b, proxyClassType.getName(), "writeReplace", new String[0]);
        b.add(1);
        b.addIconst(0);
        b.addAnewarray("java.lang.Object");
        b.addInvokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        b.add(176);
        b.setMaxLocals(1);
        return b;
    }

    protected void addMethodsFromClass(ClassFile proxyClassType) {
        try {
            for (Class<?> cls = this.beanType; cls != null; cls = cls.getSuperclass()) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class && !method.getName().equals("toString")) continue;
                    try {
                        proxyClassType.addMethod(MethodUtils.makeMethod(1, method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), this.createInterceptorBody(proxyClassType, method), proxyClassType.getConstPool()));
                        log.trace("Adding method " + method);
                    }
                    catch (DuplicateMemberException e) {
                        // empty catch block
                    }
                }
            }
            for (Class<?> c : this.additionalInterfaces) {
                for (Method method : c.getMethods()) {
                    try {
                        proxyClassType.addMethod(MethodUtils.makeMethod(1, method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), this.createInterceptorBody(proxyClassType, method), proxyClassType.getConstPool()));
                        log.trace("Adding method " + method);
                    }
                    catch (DuplicateMemberException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected Bytecode createInterceptorBody(ClassFile file, Method method) throws NotFoundException {
        Bytecode b = new Bytecode(file.getConstPool());
        String[] ptypes = new String[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            ptypes[i] = DescriptorUtils.classToStringRepresentation(method.getParameterTypes()[i]);
        }
        ProxyFactory.invokeMethodHandler(file, b, method.getDeclaringClass().getName(), method.getName(), ptypes, DescriptorUtils.classToStringRepresentation(method.getReturnType()), true, null);
        return b;
    }

    protected static void invokeMethodHandler(ClassFile file, Bytecode b, String declaringClass, String methodName, String[] methodParameters, String returnType, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver) {
        b.add(42);
        b.addGetfield(file.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(42);
        if (bytecodeMethodResolver == null) {
            ProxyFactory.getDeclaredMethod(b, declaringClass, methodName, methodParameters);
        } else {
            bytecodeMethodResolver.getDeclaredMethod(file, b, declaringClass, methodName, methodParameters);
        }
        b.add(1);
        b.addIconst(methodParameters.length);
        b.addAnewarray("java.lang.Object");
        int localVariableCount = 1;
        for (int i = 0; i < methodParameters.length; ++i) {
            String typeString = methodParameters[i];
            b.add(89);
            b.addIconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary(b, typeString);
            b.add(83);
            if (DescriptorUtils.isWide(typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.addInvokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        if (addReturnInstruction) {
            if (returnType.equals("V")) {
                b.add(177);
            } else if (DescriptorUtils.isPrimitive(returnType)) {
                Boxing.unbox(b, returnType);
                if (returnType.equals("D")) {
                    b.add(175);
                } else if (returnType.equals("F")) {
                    b.add(174);
                } else if (returnType.equals("J")) {
                    b.add(173);
                } else {
                    b.add(172);
                }
            } else {
                String castType = returnType;
                if (!returnType.startsWith("[")) {
                    castType = returnType.substring(1).substring(0, returnType.length() - 2);
                }
                b.addCheckcast(castType);
                b.add(176);
            }
            if (b.getMaxLocals() < localVariableCount) {
                b.setMaxLocals(localVariableCount);
            }
        }
    }

    protected void addSpecialMethods(ClassFile proxyClassType) {
        try {
            for (Method method : LifecycleMixin.class.getDeclaredMethods()) {
                log.trace("Adding method " + method);
                proxyClassType.addMethod(MethodUtils.makeMethod(1, method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), this.createInterceptorBody(proxyClassType, method), proxyClassType.getConstPool()));
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getDeclaredMethod("getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getDeclaredMethod("getTargetClass", new Class[0]);
            proxyClassType.addMethod(MethodUtils.makeMethod(1, getInstanceMethod.getReturnType(), getInstanceMethod.getName(), getInstanceMethod.getParameterTypes(), getInstanceMethod.getExceptionTypes(), this.createInterceptorBody(proxyClassType, getInstanceMethod), proxyClassType.getConstPool()));
            proxyClassType.addMethod(MethodUtils.makeMethod(1, getInstanceClassMethod.getReturnType(), getInstanceClassMethod.getName(), getInstanceClassMethod.getParameterTypes(), getInstanceClassMethod.getExceptionTypes(), this.createInterceptorBody(proxyClassType, getInstanceClassMethod), proxyClassType.getConstPool()));
            Method setMethodHandlerMethod = ProxyObject.class.getDeclaredMethod("setHandler", MethodHandler.class);
            proxyClassType.addMethod(MethodUtils.makeMethod(1, setMethodHandlerMethod.getReturnType(), setMethodHandlerMethod.getName(), setMethodHandlerMethod.getParameterTypes(), setMethodHandlerMethod.getExceptionTypes(), ProxyFactory.generateSetMethodHandlerBody(proxyClassType), proxyClassType.getConstPool()));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private static Bytecode generateSetMethodHandlerBody(ClassFile file) {
        Bytecode b = new Bytecode(file.getConstPool(), 3, 2);
        b.add(42);
        b.add(43);
        b.addPutfield(file.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(177);
        return b;
    }

    protected static void getDeclaredMethod(Bytecode code, Method method) {
        String[] ptypes = new String[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            ptypes[i] = method.getParameterTypes()[i].getName();
        }
        ProxyFactory.getDeclaredMethod(code, method.getDeclaringClass().getName(), method.getName(), ptypes);
    }

    protected static void getDeclaredMethod(Bytecode code, String declaringClass, String methodName, String[] parameterTypes) {
        BytecodeUtils.pushClassType(code, declaringClass);
        code.addLdc(methodName);
        code.addIconst(parameterTypes.length);
        code.addAnewarray("java.lang.Class");
        for (int i = 0; i < parameterTypes.length; ++i) {
            code.add(89);
            code.addIconst(i);
            String type = parameterTypes[i];
            BytecodeUtils.pushClassType(code, type);
            code.add(83);
        }
        code.addInvokevirtual("java.lang.Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    protected static interface BytecodeMethodResolver {
        public void getDeclaredMethod(ClassFile var1, Bytecode var2, String var3, String var4, String[] var5);
    }
}

