/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.bootstrap.api.Lifecycle;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.context.AbstractApplicationContext;
import org.jboss.weld.context.AbstractThreadLocalMapContext;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.SessionContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.context.beanstore.HashMapBeanStore;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.jboss.weld.servlet.HttpPassThruSessionBeanStore;
import org.slf4j.cal10n.LocLogger;

public class ContextLifecycle
implements Lifecycle,
Service {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final AbstractApplicationContext applicationContext;
    private final AbstractApplicationContext singletonContext;
    private final SessionContext sessionContext;
    private final ConversationContext conversationContext;
    private final RequestContext requestContext;
    private final DependentContext dependentContext;

    public ContextLifecycle(AbstractApplicationContext applicationContext, AbstractApplicationContext singletonContext, SessionContext sessionContext, ConversationContext conversationContext, RequestContext requestContext, DependentContext dependentContext) {
        this.applicationContext = applicationContext;
        this.singletonContext = singletonContext;
        this.sessionContext = sessionContext;
        this.conversationContext = conversationContext;
        this.requestContext = requestContext;
        this.dependentContext = dependentContext;
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AbstractApplicationContext getSingletonContext() {
        return this.singletonContext;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public DependentContext getDependentContext() {
        return this.dependentContext;
    }

    public boolean isRequestActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.requestContext.isActive() && this.dependentContext.isActive();
    }

    public boolean isApplicationActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.dependentContext.isActive();
    }

    public boolean isConversationActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.sessionContext.isActive() && this.conversationContext.isActive() && this.dependentContext.isActive();
    }

    public boolean isSessionActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.sessionContext.isActive() && this.dependentContext.isActive();
    }

    public void cleanup() {
        this.dependentContext.cleanup();
        this.requestContext.cleanup();
        this.conversationContext.cleanup();
        this.sessionContext.cleanup();
        this.singletonContext.cleanup();
        this.applicationContext.cleanup();
    }

    public void beginApplication(BeanStore applicationBeanStore) {
        log.trace(ContextMessage.APPLICATION_STARTED, "");
        this.activateApplicationContext(applicationBeanStore);
        this.activateSingletonContext();
    }

    private void activateApplicationContext(BeanStore applicationBeanStore) {
        this.activateContext(this.applicationContext, applicationBeanStore);
    }

    private void activateContext(AbstractApplicationContext context, BeanStore beanStore) {
        if (beanStore == null) {
            throw new IllegalArgumentException("null bean store for " + context);
        }
        context.setBeanStore(beanStore);
        context.setActive(true);
    }

    private void activateSingletonContext() {
        this.activateContext(this.singletonContext, (BeanStore)new ConcurrentHashMapBeanStore());
    }

    public void beginRequest(String id, BeanStore requestBeanStore) {
        log.trace(ContextMessage.REQUEST_STARTED, id);
        this.activateDependentContext();
        this.activateRequestContext(requestBeanStore);
        this.activateConversationContext();
        this.activateSessionContext();
    }

    private void activateDependentContext() {
        this.dependentContext.setActive(true);
    }

    private void activateRequestContext(BeanStore requestBeanStore) {
        this.activateContext(this.requestContext, requestBeanStore);
    }

    private void activateContext(AbstractThreadLocalMapContext context, BeanStore beanStore) {
        if (beanStore == null) {
            throw new IllegalArgumentException("null bean store for " + context);
        }
        context.setBeanStore(beanStore);
        context.setActive(true);
    }

    private void activateConversationContext() {
        this.activateContext(this.conversationContext, (BeanStore)new HashMapBeanStore());
    }

    private void activateSessionContext() {
        this.activateContext(this.sessionContext, (BeanStore)new HttpPassThruSessionBeanStore());
    }

    public void endApplication() {
        log.trace(ContextMessage.APPLICATION_ENDED, "");
        this.destroyApplicationContext();
        this.destroySingletonContext();
    }

    private void destroyApplicationContext() {
        this.destroyContext(this.applicationContext);
    }

    private void destroyContext(AbstractApplicationContext context) {
        if (context.getBeanStore() == null) {
            return;
        }
        this.activateContext(context, context.getBeanStore());
        context.destroy();
        this.deactivateContext(context);
    }

    private void deactivateContext(AbstractApplicationContext context) {
        context.setBeanStore(null);
        context.setActive(false);
    }

    private void destroySingletonContext() {
        this.destroyContext(this.singletonContext);
    }

    public void endRequest(String id, BeanStore requestBeanStore) {
        log.trace(ContextMessage.REQUEST_ENDED, id);
        this.deactivateDependentContext();
        this.destroyRequestContext(requestBeanStore);
        this.deactivateConversationContext();
        this.deactivateSessionContext();
    }

    private void deactivateDependentContext() {
        this.dependentContext.setActive(false);
    }

    private void destroyRequestContext(BeanStore requestBeanStore) {
        this.destroyContext(this.requestContext, requestBeanStore);
    }

    private void deactivateConversationContext() {
        this.deactivateContext(this.conversationContext);
    }

    public void deactivateSessionContext() {
        this.deactivateContext(this.sessionContext);
    }

    public void endSession(String id, BeanStore sessionBeanStore) {
        log.trace(ContextMessage.SESSION_ENDED, id);
        this.destroySessionContext(sessionBeanStore);
    }

    private void destroyConversationContext() {
        this.destroyContext(this.conversationContext, this.conversationContext.getBeanStore());
    }

    private void destroySessionContext(BeanStore sessionBeanStore) {
        this.destroyContext(this.sessionContext, sessionBeanStore);
    }

    private void destroyContext(AbstractThreadLocalMapContext context, BeanStore beanStore) {
        this.activateContext(context, beanStore);
        context.destroy();
        this.deactivateContext(context);
    }

    private void deactivateContext(AbstractThreadLocalMapContext context) {
        context.setBeanStore(null);
        context.setActive(false);
    }

    public void restoreSession(String id, BeanStore sessionBeanStore) {
        log.trace(ContextMessage.SESSION_RESTORED, id);
        this.activateSessionContext(sessionBeanStore);
    }

    private void activateSessionContext(BeanStore sessionBeanStore) {
        this.activateContext(this.sessionContext, sessionBeanStore);
    }

    public void restoreConversation(String id, BeanStore conversationBeanStore) {
        log.trace(ContextMessage.CONVERSATION_RESTORED, id);
        this.activateConversationContext(new HashMapBeanStore());
        this.conversationContext.loadTransientBeanStore(conversationBeanStore);
    }

    private void activateConversationContext(BeanStore conversationBeanStore) {
        this.activateContext(this.conversationContext, conversationBeanStore);
    }

    public void setupConversationContext() {
        this.activateConversationContext();
    }

    public void teardownConversationContext() {
        if (this.getConversationContext().getBeanStore() != null) {
            this.destroyConversationContext();
        }
    }

    public boolean isSessionContextActive() {
        return this.sessionContext.isActive();
    }

    public boolean isRequestContextActive() {
        return this.requestContext.isActive();
    }
}

