/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.introspector.WeldAnnotation;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.jlr.WeldAnnotationImpl;
import org.jboss.weld.introspector.jlr.WeldClassImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.spi.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements Service {
    private final ConcurrentMap<TypeHolder<?>, WeldClass<?>> classes;
    private final ConcurrentMap<AnnotatedType<?>, WeldClass<?>> annotatedTypes;
    private final ConcurrentMap<Class<? extends Annotation>, WeldAnnotation<?>> annotations;
    private final TypeStore typeStore;

    public ClassTransformer(TypeStore typeStore) {
        MapMaker maker = new MapMaker();
        this.classes = maker.makeComputingMap(new TransformTypeToWeldClass(this));
        this.annotatedTypes = maker.makeComputingMap(new TransformAnnotatedTypeToWeldClass(this));
        this.annotations = maker.makeComputingMap(new TransformClassToWeldAnnotation(this));
        this.typeStore = typeStore;
    }

    public <T> WeldClass<T> loadClass(Class<T> rawType, Type baseType) {
        try {
            return (WeldClass)this.classes.get(new TypeHolder(rawType, baseType));
        }
        catch (ComputationException e) {
            if (e.getCause() instanceof NoClassDefFoundError || e.getCause() instanceof TypeNotPresentException) {
                throw new ResourceLoadingException("Error loading class " + rawType.getName(), e.getCause());
            }
            throw e;
        }
    }

    public <T> WeldClass<T> loadClass(Class<T> clazz) {
        try {
            return (WeldClass)this.classes.get(new TypeHolder(clazz, clazz));
        }
        catch (ComputationException e) {
            if (e.getCause() instanceof NoClassDefFoundError || e.getCause() instanceof TypeNotPresentException) {
                throw new ResourceLoadingException("Error loading class " + clazz.getName(), e.getCause());
            }
            throw e;
        }
    }

    public <T> WeldClass<T> loadClass(AnnotatedType<T> clazz) {
        return (WeldClass)this.annotatedTypes.get(clazz);
    }

    public <T extends Annotation> WeldAnnotation<T> loadAnnotation(Class<T> clazz) {
        return (WeldAnnotation)this.annotations.get(clazz);
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    @Override
    public void cleanup() {
        this.annotatedTypes.clear();
        this.annotations.clear();
        this.classes.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeHolder<T> {
        private final Class<T> rawType;
        private final Type baseType;

        private TypeHolder(Class<T> rawType, Type baseType) {
            this.rawType = rawType;
            this.baseType = baseType;
        }

        public Type getBaseType() {
            return this.baseType;
        }

        public Class<T> getRawType() {
            return this.rawType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeHolder) {
                TypeHolder that = (TypeHolder)obj;
                return this.getBaseType().equals(that.getBaseType());
            }
            return false;
        }

        public int hashCode() {
            return this.getBaseType().hashCode();
        }

        public String toString() {
            return this.getBaseType().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformAnnotatedTypeToWeldClass
    implements Function<AnnotatedType<?>, WeldClass<?>> {
        private final ClassTransformer classTransformer;

        private TransformAnnotatedTypeToWeldClass(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public WeldClass<?> apply(AnnotatedType<?> from) {
            return WeldClassImpl.of(from, this.classTransformer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformClassToWeldAnnotation
    implements Function<Class<? extends Annotation>, WeldAnnotation<?>> {
        private final ClassTransformer classTransformer;

        private TransformClassToWeldAnnotation(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public WeldAnnotation<?> apply(Class<? extends Annotation> from) {
            return WeldAnnotationImpl.of(from, this.classTransformer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformTypeToWeldClass
    implements Function<TypeHolder<?>, WeldClass<?>> {
        private final ClassTransformer classTransformer;

        private TransformTypeToWeldClass(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public WeldClass<?> apply(TypeHolder<?> from) {
            return WeldClassImpl.of(from.getRawType(), from.getBaseType(), this.classTransformer);
        }
    }
}

