/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Method;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.MethodInfo;
import org.jboss.weld.util.bytecode.DescriptorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodUtils {
    private MethodUtils() {
    }

    public static MethodInfo makeMethod(int modifiers, Class<?> returnType, String mname, Class<?>[] parameters, Class<?>[] exceptions, Bytecode body, ConstPool pool) {
        StringBuilder desc = new StringBuilder("(");
        if (parameters != null) {
            for (Class<?> p : parameters) {
                desc.append(DescriptorUtils.classToStringRepresentation(p));
            }
        }
        desc.append(")");
        desc.append(DescriptorUtils.classToStringRepresentation(returnType));
        MethodInfo meth = new MethodInfo(pool, mname, desc.toString());
        meth.setAccessFlags(modifiers);
        String[] ex = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            ex[i] = exceptions[i].getName().replace('.', '/');
        }
        ExceptionsAttribute exAt = new ExceptionsAttribute(pool);
        exAt.setExceptions(ex);
        meth.setExceptionsAttribute(exAt);
        CodeAttribute ca = body.toCodeAttribute();
        meth.setCodeAttribute(ca);
        try {
            ca.computeMaxStack();
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
        return meth;
    }

    public static int calculateMaxLocals(Method method) {
        int ret = 0;
        if ((method.getModifiers() & 8) == 0) {
            ret = 1;
        }
        ret += method.getParameterTypes().length;
        for (Class<?> i : method.getParameterTypes()) {
            if (i != Double.TYPE && i != Long.TYPE) continue;
            ++ret;
        }
        return ret;
    }
}

