/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection.instantiation;

import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.instantiation.Instantiator;
import org.jboss.weld.util.reflection.instantiation.ReflectionFactoryInstantiator;
import org.jboss.weld.util.reflection.instantiation.UnsafeInstantiator;

public class InstantiatorFactory
implements Service {
    private static Instantiator availableInstantiator;
    private static boolean enabled;
    private static final List<Instantiator> instantiators;

    public static Instantiator getInstantiator() {
        return availableInstantiator;
    }

    public static boolean useInstantiators() {
        return enabled;
    }

    public void cleanup() {
        instantiators.clear();
    }

    static {
        instantiators = new ArrayList<Instantiator>(){
            {
                this.add(new UnsafeInstantiator());
                this.add(new ReflectionFactoryInstantiator());
            }
        };
        for (Instantiator instantiator : instantiators) {
            if (!instantiator.isAvailable()) continue;
            availableInstantiator = instantiator;
            break;
        }
        enabled = Container.instance().services().get(ResourceLoader.class).getResource("META-INF/org.jboss.weld.enableUnsafeProxies") != null;
    }
}

