/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.se.ShutdownManager;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.discovery.url.WeldSEResourceLoader;
import org.jboss.weld.environment.se.discovery.url.WeldSEUrlDeployment;
import org.jboss.weld.resources.spi.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weld {
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private ShutdownManager shutdownManager;

    public WeldContainer initialize() {
        WeldSEResourceLoader resourceLoader = new WeldSEResourceLoader();
        Bootstrap bootstrap = null;
        try {
            bootstrap = (Bootstrap)resourceLoader.classForName(BOOTSTRAP_IMPL_CLASS_NAME).newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", ex);
        }
        Deployment deployment = this.createDeployment(resourceLoader, bootstrap);
        bootstrap.startContainer(Environments.SE, deployment);
        bootstrap.startInitialization();
        bootstrap.deployBeans();
        this.getInstanceByType(bootstrap.getManager(deployment.loadBeanDeploymentArchive(ShutdownManager.class)), ShutdownManager.class, new Annotation[0]).setBootstrap(bootstrap);
        bootstrap.validateBeans();
        bootstrap.endInitialization();
        this.shutdownManager = this.getInstanceByType(bootstrap.getManager(deployment.loadBeanDeploymentArchive(ShutdownManager.class)), ShutdownManager.class, new Annotation[0]);
        return this.getInstanceByType(bootstrap.getManager(deployment.loadBeanDeploymentArchive(WeldContainer.class)), WeldContainer.class, new Annotation[0]);
    }

    protected Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        return new WeldSEUrlDeployment(resourceLoader, bootstrap);
    }

    protected <T> T getInstanceByType(BeanManager manager, Class<T> type, Annotation ... bindings) {
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        if (bean == null) {
            throw new UnsatisfiedResolutionException("Unable to resolve a bean for " + type + " with bindings " + Arrays.asList(bindings));
        }
        CreationalContext cc = manager.createCreationalContext(bean);
        return type.cast(manager.getReference(bean, type, cc));
    }

    public void shutdown() {
        this.shutdownManager.shutdown();
    }
}

