package org.jboss.weld.environment.se.discovery;

import javax.enterprise.inject.spi.Extension;

import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.se.discovery.url.WeldSEResourceLoader;

/**
 * Implements the basic requirements of a {@link Deployment}. Provides a service
 * registry.
 * 
 * Suitable for extension by those who need to build custom {@link Deployment}
 * implementations.
 * 
 * @author Pete Muir
 * 
 */
public abstract class AbstractWeldSEDeployment implements Deployment
{

   public static final String[] RESOURCES = { "META-INF/beans.xml" };

   private final ServiceRegistry serviceRegistry;
   private final Iterable<Metadata<Extension>> extensions;

   public AbstractWeldSEDeployment(Bootstrap bootstrap)
   {
      this.serviceRegistry = new SimpleServiceRegistry();
      this.extensions = bootstrap.loadExtensions(WeldSEResourceLoader.getClassLoader());
   }

   public ServiceRegistry getServices()
   {
      return serviceRegistry;
   }
      
   public Iterable<Metadata<Extension>> getExtensions()
   {
      return extensions;
   }


}