/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.bean.proxy.util.SerializableProxy;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.slf4j.cal10n.LocLogger;

public class ProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 5293834510764991583L;
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private BeanInstance beanInstance;

    public ProxyMethodHandler(BeanInstance beanInstance) {
        this.beanInstance = beanInstance;
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (thisMethod == null) {
            log.trace("MethodHandler processing returning bean instance for " + self.getClass());
            if (this.beanInstance == null) {
                throw new WeldException(BeanMessage.BEAN_INSTANCE_NOT_SET_ON_PROXY, new Object[0]);
            }
            return this.beanInstance.getInstance();
        }
        log.trace("MethodHandler processing call to " + thisMethod + " for " + self.getClass());
        if (thisMethod.getDeclaringClass().equals(TargetInstanceProxy.class)) {
            if (this.beanInstance == null) {
                throw new WeldException(BeanMessage.BEAN_INSTANCE_NOT_SET_ON_PROXY, new Object[0]);
            }
            if (thisMethod.getName().equals("getTargetInstance")) {
                return this.beanInstance.getInstance();
            }
            if (thisMethod.getName().equals("getTargetClass")) {
                return this.beanInstance.getInstanceType();
            }
            return null;
        }
        if (thisMethod.getName().equals("writeReplace")) {
            return new SerializableProxy(self);
        }
        if (thisMethod.getName().equals("_initMH")) {
            log.trace("Setting new MethodHandler with bean instance for " + args[0] + " on " + self.getClass());
            return new ProxyMethodHandler(new TargetBeanInstance(args[0]));
        }
        if (this.beanInstance == null) {
            throw new WeldException(BeanMessage.BEAN_INSTANCE_NOT_SET_ON_PROXY, new Object[0]);
        }
        Object instance = this.beanInstance.getInstance();
        Object result = this.beanInstance.invoke(instance, thisMethod, args);
        if (result != null && result == instance) {
            return self;
        }
        return result;
    }
}

