/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;
import org.jboss.weld.util.reflection.Reflections;

public class ContextualStoreImpl
implements ContextualStore {
    private static final String GENERATED_ID_PREFIX = ContextualStoreImpl.class.getName();
    private final ConcurrentMap<Contextual<?>, String> contextuals;
    private final ConcurrentMap<String, Contextual<?>> contextualsInverse;
    private final ConcurrentMap<String, Contextual<?>> passivationCapableContextuals;
    private final AtomicInteger idGenerator = new AtomicInteger(0);

    public ContextualStoreImpl() {
        this.contextuals = new ConcurrentHashMap();
        this.contextualsInverse = new ConcurrentHashMap();
        this.passivationCapableContextuals = new ConcurrentHashMap();
    }

    @Override
    public <C extends Contextual<I>, I> C getContextual(String id) {
        if (id.startsWith(GENERATED_ID_PREFIX)) {
            return (C)((Contextual)this.contextualsInverse.get(id));
        }
        return (C)((Contextual)this.passivationCapableContextuals.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"}, justification="Using non-standard semantics of putIfAbsent")
    public String putIfAbsent(Contextual<?> contextual) {
        if (contextual instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)((Object)contextual);
            String id = passivationCapable.getId();
            this.passivationCapableContextuals.putIfAbsent(id, contextual);
            return id;
        }
        String id = (String)this.contextuals.get(contextual);
        if (id != null) {
            return id;
        }
        Contextual<?> contextual2 = contextual;
        synchronized (contextual2) {
            id = (String)this.contextuals.get(contextual);
            if (id == null) {
                id = GENERATED_ID_PREFIX + this.idGenerator.incrementAndGet();
                this.contextuals.put(contextual, id);
                this.contextualsInverse.put(id, contextual);
            }
            return id;
        }
    }

    @Override
    public <C extends Contextual<I>, I> SerializableContextual<C, I> getSerializableContextual(Contextual<I> contextual) {
        return new SerializableContextualImpl((Contextual)Reflections.cast(contextual), this);
    }

    @Override
    public <C extends Contextual<I>, I> SerializableContextualInstance<C, I> getSerializableContextualInstance(Contextual<I> contextual, I instance, CreationalContext<I> creationalContext) {
        return new SerializableContextualInstanceImpl<Contextual, I>((Contextual)Reflections.cast(contextual), instance, creationalContext, this);
    }

    @Override
    public void cleanup() {
        this.contextuals.clear();
        this.contextualsInverse.clear();
        this.passivationCapableContextuals.clear();
    }
}

