/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.util.ArrayList;
import java.util.Collection;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.metadata.MethodMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorInvocation<T> {
    private T instance;
    private InterceptorMetadata<?> interceptorMetadata;
    private InterceptionType interceptionType;

    public InterceptorInvocation(T instance, InterceptorMetadata<?> interceptorMetadata, InterceptionType interceptionType) {
        this.instance = instance;
        this.interceptorMetadata = interceptorMetadata;
        this.interceptionType = interceptionType;
    }

    public Collection<InterceptorMethodInvocation> getInterceptorMethodInvocations() {
        ArrayList<InterceptorMethodInvocation> interceptorMethodInvocations = new ArrayList<InterceptorMethodInvocation>();
        for (MethodMetadata method : this.interceptorMetadata.getInterceptorMethods(this.interceptionType)) {
            interceptorMethodInvocations.add(new InterceptorMethodInvocation(this.instance, method));
        }
        return interceptorMethodInvocations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InterceptorMethodInvocation {
        T instance;
        MethodMetadata method;

        InterceptorMethodInvocation(T instance, MethodMetadata method) {
            this.instance = instance;
            this.method = method;
        }

        Object invoke(InvocationContext invocationContext) throws Exception {
            if (invocationContext != null) {
                return this.method.getJavaMethod().invoke(this.instance, invocationContext);
            }
            return this.method.getJavaMethod().invoke(this.instance, new Object[0]);
        }

        public MethodMetadata getMethod() {
            return this.method;
        }
    }
}

