/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducerBean<X, T, S extends Member>
extends AbstractReceiverBean<X, T, S> {
    private static final Function<Class<?>, Boolean> SERIALIZABLE_CHECK = new Function<Class<?>, Boolean>(){

        @Override
        public Boolean apply(Class<?> from) {
            return Reflections.isSerializable(from);
        }
    };
    private Producer<T> producer;
    private boolean passivationCapableBean;
    private boolean passivationCapableDependency;
    private ConcurrentMap<Class<?>, Boolean> serializationCheckCache = new MapMaker().makeComputingMap(SERIALIZABLE_CHECK);
    private DisposalMethod<X, ?> disposalMethodBean;
    private CurrentInjectionPoint currentInjectionPoint;

    public AbstractProducerBean(BeanAttributes<T> attributes, String idSuffix, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, idSuffix, declaringBean, beanManager, services);
    }

    @Override
    public abstract WeldMember<T, ? super X, S> getWeldAnnotated();

    @Override
    public Class<?> getBeanClass() {
        return this.getDeclaringBean().getBeanClass();
    }

    protected void initType() {
        try {
            this.type = this.getWeldAnnotated().getJavaClass();
        }
        catch (ClassCastException e) {
            Type type = Beans.getDeclaredBeanType(this.getClass());
            throw new WeldException(BeanMessage.PRODUCER_CAST_ERROR, (Throwable)e, this.getWeldAnnotated().getJavaClass(), type == null ? " unknown " : type);
        }
    }

    protected void checkProducerReturnType() {
        if (this.getWeldAnnotated().getBaseType() instanceof TypeVariable || this.getWeldAnnotated().getBaseType() instanceof WildcardType) {
            throw new DefinitionException(BeanMessage.RETURN_TYPE_MUST_BE_CONCRETE, this.getWeldAnnotated().getBaseType());
        }
        if (this.getWeldAnnotated().isParameterizedType()) {
            for (Type type : this.getWeldAnnotated().getActualTypeArguments()) {
                if (!Dependent.class.equals(this.getScope()) && type instanceof TypeVariable) {
                    throw new DefinitionException(BeanMessage.PRODUCER_METHOD_WITH_TYPE_VARIABLE_RETURN_TYPE_MUST_BE_DEPENDENT, this.getWeldAnnotated());
                }
                if (!(type instanceof WildcardType)) continue;
                throw new DefinitionException(BeanMessage.PRODUCER_METHOD_CANNOT_HAVE_A_WILDCARD_RETURN_TYPE, this.getWeldAnnotated());
            }
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.getDeclaringBean().initialize(environment);
        super.initialize(environment);
        this.checkProducerReturnType();
        this.initPassivationCapable();
        this.initDisposalMethod(environment);
        this.currentInjectionPoint = Container.instance().services().get(CurrentInjectionPoint.class);
    }

    private void initPassivationCapable() {
        this.passivationCapableBean = !this.getWeldAnnotated().isFinal() || Serializable.class.isAssignableFrom(this.getWeldAnnotated().getJavaClass());
        this.passivationCapableDependency = Container.instance().services().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isNormal() ? true : this.getScope().equals(Dependent.class) && this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.passivationCapableDependency;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    protected void checkReturnValue(T instance) {
        if (instance == null && !this.isDependent()) {
            throw new IllegalProductException(BeanMessage.NULL_NOT_ALLOWED_FROM_PRODUCER, this.getProducer());
        }
        if (instance != null) {
            boolean passivating = this.beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
            boolean instanceSerializable = this.isTypeSerializable(instance.getClass());
            if (passivating && !instanceSerializable) {
                throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCT_ERROR, this.getProducer());
            }
            InjectionPoint injectionPoint = this.currentInjectionPoint.peek();
            if (injectionPoint != null && injectionPoint.getBean() != null && !instanceSerializable && Beans.isPassivatingScope(injectionPoint.getBean(), this.beanManager)) {
                if (injectionPoint.getMember() instanceof Field) {
                    if (!injectionPoint.isTransient() && instance != null && !instanceSerializable) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_FIELD_INJECTION_ERROR, this, injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    if (method.isAnnotationPresent(Inject.class)) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_INITIALIZER_PARAM_INJECTION_ERROR, this, injectionPoint);
                    }
                    if (method.isAnnotationPresent(Produces.class)) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCER_PARAM_INJECTION_ERROR, this, injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Constructor) {
                    throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_CONSTRUCTOR_PARAM_INJECTION_ERROR, this, injectionPoint);
                }
            }
        }
    }

    @Override
    protected void checkType() {
    }

    protected boolean isTypeSerializable(Class<?> clazz) {
        return (Boolean)this.serializationCheckCache.get(clazz);
    }

    public void setProducer(Producer<T> producer) {
        this.producer = producer;
    }

    public Producer<T> getProducer() {
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(CreationalContext<T> creationalContext) {
        T t;
        this.storeMetadata(creationalContext);
        try {
            T instance = this.getProducer().produce(creationalContext);
            this.checkReturnValue(instance);
            t = instance;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (!this.getDeclaringBean().isDependent()) break block3;
                creationalContext.release();
            }
            throw throwable;
        }
        if (this.getDeclaringBean().isDependent()) {
            creationalContext.release();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        block9: {
            boolean loadMetadata;
            boolean bl = loadMetadata = this.disposalMethodBean != null && this.disposalMethodBean.hasInjectionPointMetadataParameter();
            if (loadMetadata) {
                WeldCreationalContext<T> ctx = this.getWeldCreationalContext(creationalContext);
                InjectionPoint ip = ctx.loadInjectionPoint();
                if (ip == null) {
                    throw new IllegalStateException("Unable to restore InjectionPoint instance.");
                }
                this.currentInjectionPoint.push(ip);
            }
            try {
                if (AbstractProducer.class.isAssignableFrom(this.producer.getClass())) {
                    ((AbstractProducer)this.producer).dispose(instance, creationalContext);
                } else {
                    this.producer.dispose(instance);
                }
                Object var7_6 = null;
                if (!loadMetadata) break block9;
                this.currentInjectionPoint.pop();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (loadMetadata) {
                    this.currentInjectionPoint.pop();
                }
                if (this.getDeclaringBean().isDependent()) {
                    creationalContext.release();
                }
                throw throwable;
            }
        }
        if (this.getDeclaringBean().isDependent()) {
            creationalContext.release();
        }
    }

    private void storeMetadata(CreationalContext<T> creationalContext) {
        if (this.disposalMethodBean != null) {
            if (this.disposalMethodBean.hasBeanMetadataParameter()) {
                WeldCreationalContext<T> ctx = this.getWeldCreationalContext(creationalContext);
                this.checkValue(ctx.getContextual());
                ctx.storeContextual();
            }
            if (this.disposalMethodBean.hasInjectionPointMetadataParameter()) {
                InjectionPoint ip = this.currentInjectionPoint.peek();
                this.checkValue(ip);
                this.getWeldCreationalContext(creationalContext).storeInjectionPoint(ip);
            }
        }
    }

    private <A> WeldCreationalContext<A> getWeldCreationalContext(CreationalContext<A> ctx) {
        if (ctx instanceof WeldCreationalContext) {
            return (WeldCreationalContext)Reflections.cast(ctx);
        }
        throw new IllegalArgumentException("Unable to store values in " + ctx);
    }

    private void checkValue(Object object) {
        InjectionPoint ip = this.currentInjectionPoint.peek();
        if (ip != null && Beans.isPassivatingScope(ip.getBean(), this.beanManager) && !this.isTypeSerializable(object.getClass())) {
            throw new IllegalArgumentException("Unable to store non-serializable " + object + " as a dependency of " + this);
        }
    }

    protected void initDisposalMethod(BeanDeployerEnvironment environment) {
        Set disposalBeans = environment.resolveDisposalBeans(this.getTypes(), this.getQualifiers(), this.getDeclaringBean());
        if (disposalBeans.size() == 1) {
            this.disposalMethodBean = disposalBeans.iterator().next();
        } else if (disposalBeans.size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_DISPOSAL_METHODS, this, disposalBeans);
        }
    }

    public DisposalMethod<X, ?> getDisposalMethod() {
        return this.disposalMethodBean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractProducer
    implements Producer<T> {
        protected AbstractProducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose(T instance) {
            CreationalContext ctx = AbstractProducerBean.this.beanManager.createCreationalContext((Contextual)AbstractProducerBean.this);
            try {
                this.dispose(instance, ctx);
                Object var4_3 = null;
                ctx.release();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ctx.release();
                throw throwable;
            }
        }

        public void dispose(T instance, CreationalContext<T> ctx) {
            if (AbstractProducerBean.this.disposalMethodBean != null) {
                AbstractProducerBean.this.disposalMethodBean.invokeDisposeMethod(instance, ctx);
            }
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return (Set)Reflections.cast(AbstractProducerBean.this.getWeldInjectionPoints());
        }
    }
}

