/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.interceptor.Interceptor;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeFactory;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.enums.EnumInjectionTarget;
import org.jboss.weld.enums.EnumService;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.introspector.DiscoveredExternalAnnotatedType;
import org.jboss.weld.introspector.ExternalAnnotatedType;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private transient LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private transient XLogger xlog = LoggerFactory.loggerFactory().getXLogger(Category.CLASS_LOADING);
    private final Set<WeldClass<?>> classes = new HashSet();
    private final Map<WeldClass<?>, Extension> classSource = new HashMap();
    private final Set<Class<?>> vetoedClasses = new HashSet();
    private final ResourceLoader resourceLoader;
    private final ClassTransformer classTransformer;

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        super(manager, services, new BeanDeployerEnvironment(ejbDescriptors, manager));
        this.resourceLoader = manager.getServices().get(ResourceLoader.class);
        this.classTransformer = Container.instance().services().get(ClassTransformer.class);
    }

    public BeanDeployer addClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = this.resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e) {
            this.log.info(BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, className);
            this.xlog.catching(XLogger.Level.INFO, e);
        }
        if (clazz != null && !clazz.isAnnotation()) {
            WeldClass<?> weldClass = null;
            try {
                weldClass = this.classTransformer.loadClass(clazz);
            }
            catch (ResourceLoadingException e) {
                this.log.info(BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, className);
                this.xlog.catching(XLogger.Level.INFO, e);
            }
            if (weldClass != null) {
                this.classes.add(weldClass);
            }
        }
        return this;
    }

    public BeanDeployer addSyntheticClass(AnnotatedType<?> clazz, Extension extension) {
        WeldClass<?> weldClass = this.classTransformer.loadClass(clazz);
        this.classes.add(weldClass);
        this.classSource.put(weldClass, extension);
        return this;
    }

    public BeanDeployer addClasses(Iterable<String> classes) {
        for (String className : classes) {
            this.addClass(className);
        }
        return this;
    }

    public void processAnnotatedTypes() {
        HashSet processedClasses = new HashSet();
        Iterator<WeldClass<?>> iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            WeldClass<?> weldClass = iterator.next();
            boolean synthetic = this.classSource.containsKey(weldClass);
            ProcessAnnotatedTypeImpl<?> event = synthetic ? ProcessAnnotatedTypeFactory.create(this.getManager(), weldClass, this.classSource.get(weldClass)) : ProcessAnnotatedTypeFactory.create(this.getManager(), weldClass);
            event.fire();
            if (event.isVeto()) {
                iterator.remove();
                if (!weldClass.isDiscovered()) continue;
                this.vetoedClasses.add(weldClass.getJavaClass());
                continue;
            }
            boolean dirty = event.isDirty();
            if (dirty) {
                iterator.remove();
                AnnotatedType<?> modifiedType = synthetic ? ExternalAnnotatedType.of(event.getAnnotatedType()) : DiscoveredExternalAnnotatedType.of(event.getAnnotatedType());
                weldClass = this.classTransformer.loadClass(modifiedType);
            }
            boolean vetoed = Beans.isVetoed(weldClass);
            if (dirty && !vetoed) {
                processedClasses.add(weldClass);
            }
            if (dirty || !vetoed) continue;
            iterator.remove();
        }
        this.classes.addAll(processedClasses);
    }

    public void createClassBeans() {
        HashMultimap otherWeldClasses = HashMultimap.create();
        EnumService enumService = this.getManager().getServices().get(EnumService.class);
        for (WeldClass<?> weldClass : this.classes) {
            boolean managedBeanOrDecorator;
            if (Reflections.isEnum(weldClass.getJavaClass())) {
                enumService.addEnumClass((WeldClass)Reflections.cast(weldClass));
            }
            boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(weldClass.getJavaClass()) && Beans.isTypeManagedBeanOrDecoratorOrInterceptor(weldClass);
            if (managedBeanOrDecorator && weldClass.isAnnotationPresent(Decorator.class)) {
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
                continue;
            }
            if (managedBeanOrDecorator && weldClass.isAnnotationPresent(Interceptor.class)) {
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
                continue;
            }
            if (managedBeanOrDecorator && !weldClass.isAbstract()) {
                this.createManagedBean(weldClass);
                continue;
            }
            otherWeldClasses.put(weldClass.getJavaClass(), weldClass);
        }
        for (EnumInjectionTarget enumInjectionTarget : enumService.getEnumInjectionTargets()) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(enumInjectionTarget.getNewInjectionPoints());
        }
        for (InternalEjbDescriptor internalEjbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            if (this.vetoedClasses.contains(internalEjbDescriptor.getBeanClass()) || !internalEjbDescriptor.isSingleton() && !internalEjbDescriptor.isStateful() && !internalEjbDescriptor.isStateless()) continue;
            if (otherWeldClasses.containsKey(internalEjbDescriptor.getBeanClass())) {
                for (WeldClass c : otherWeldClasses.get(internalEjbDescriptor.getBeanClass())) {
                    this.createSessionBean(internalEjbDescriptor, (WeldClass)Reflections.cast(c));
                }
                continue;
            }
            this.createSessionBean(internalEjbDescriptor);
        }
    }

    public void processBeans() {
        for (Map.Entry<WeldClass<?>, AbstractClassBean<?>> entry : ((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().entrySet()) {
            entry.getValue().preInitialize();
        }
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().values());
    }

    private void processBeanAttributes(Collection<? extends AbstractBean<?, ?>> beans) {
        if (beans.isEmpty()) {
            return;
        }
        HashSet vetoedBeans = new HashSet();
        HashSet<RIBean> previouslySpecializedBeans = new HashSet<RIBean>();
        for (AbstractBean<?, ?> abstractBean : beans) {
            boolean vetoed = this.fireProcessBeanAttributes(abstractBean);
            if (vetoed) {
                vetoedBeans.add(abstractBean);
                continue;
            }
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(abstractBean);
        }
        for (AbstractBean<Object, Object> abstractBean : vetoedBeans) {
            if (abstractBean.isSpecializing()) {
                BeansClosure.getClosure(this.getManager()).removeSpecialized(abstractBean.getSpecializedBean());
                previouslySpecializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (abstractBean instanceof AbstractClassBean) {
                ((BeanDeployerEnvironment)this.getEnvironment()).removeClass((WeldClass)abstractBean.getWeldAnnotated());
            }
            if (!(abstractBean instanceof ProducerMethod)) continue;
            ((BeanDeployerEnvironment)this.getEnvironment()).removeProducerMethod((ProducerMethod)abstractBean);
        }
        this.processBeanAttributes(previouslySpecializedBeans);
    }

    public void createProducersAndObservers() {
        for (AbstractClassBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().values()) {
            this.createObserversProducersDisposers(bean);
        }
    }

    public void processProducerMethods() {
        for (Map.Entry<BeanDeployerEnvironment.WeldMethodKey<?, ?>, ProducerMethod<?, ?>> entry : ((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeanMap().entrySet()) {
            entry.getValue().preInitialize();
        }
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeanMap().values());
    }

    public void createNewBeans() {
        for (WeldClass<?> weldClass : ((BeanDeployerEnvironment)this.getEnvironment()).getNewManagedBeanClasses()) {
            this.createNewManagedBean(weldClass);
        }
        for (Map.Entry entry : ((BeanDeployerEnvironment)this.getEnvironment()).getNewSessionBeanDescriptorsFromInjectionPoint().entrySet()) {
            InternalEjbDescriptor descriptor = (InternalEjbDescriptor)entry.getKey();
            this.createNewSessionBean(descriptor, BeanAttributesFactory.forSessionBean((WeldClass)entry.getValue(), descriptor, this.getManager()));
        }
    }

    private void validateInterceptor(WeldClass<?> weldClass) {
        if (weldClass.isAnnotationPresent(Decorator.class)) {
            throw new DeploymentException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, weldClass.getName());
        }
    }

    private void validateDecorator(WeldClass<?> weldClass) {
        if (weldClass.isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, weldClass.getName());
        }
    }

    public Set<WeldClass<?>> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    public void cleanup() {
        this.classes.clear();
        this.classSource.clear();
        this.vetoedClasses.clear();
    }
}

