/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.enums;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.enums.EnumInjectionTarget;
import org.jboss.weld.enums.EnumInstanceContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.InjectionTargetValidator;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumService
implements Service {
    private final Map<Class<? extends Enum<?>>, EnumInjectionTarget<? extends Enum<?>>> injectionTargets;
    private final Set<EnumInstanceContext<?>> instances;
    private final BeanManagerImpl manager;
    private boolean injected;

    public EnumService(BeanManagerImpl manager) {
        this.manager = manager;
        this.injectionTargets = new HashMap();
        this.instances = new HashSet();
    }

    public <T extends Enum<?>> void addEnumClass(WeldClass<T> clazz) {
        if (this.injectionTargets.containsKey(clazz.getJavaClass())) {
            return;
        }
        EnumInjectionTarget<T> enumInjectionTarget = EnumInjectionTarget.of(clazz, this.manager);
        this.injectionTargets.put(clazz.getJavaClass(), enumInjectionTarget);
        this.manager.getServices().get(InjectionTargetValidator.class).addInjectionTarget(enumInjectionTarget);
    }

    public void inject() {
        if (this.injected) {
            throw new IllegalStateException(BootstrapMessage.ENUMS_ALREADY_INJECTED, new Object[0]);
        }
        this.initInstances();
        for (EnumInstanceContext<?> instance : this.instances) {
            instance.inject();
        }
        this.injected = true;
    }

    public void disinject() {
        if (this.injected) {
            for (EnumInstanceContext<?> instance : this.instances) {
                instance.destroy();
            }
            this.injected = false;
        }
    }

    public Collection<EnumInjectionTarget<? extends Enum<?>>> getEnumInjectionTargets() {
        return Collections.unmodifiableCollection(this.injectionTargets.values());
    }

    protected void initInstances() {
        for (Class<Enum<?>> clazz : this.injectionTargets.keySet()) {
            if (!clazz.isEnum()) continue;
            for (Enum<?> instance : clazz.getEnumConstants()) {
                this.addInstance(instance, this.injectionTargets.get(instance.getClass()));
            }
        }
        this.injectionTargets.clear();
    }

    protected <T extends Enum<?>> void addInstance(Enum<?> instance, EnumInjectionTarget<T> injector) {
        if (injector == null) {
            throw new IllegalStateException(BootstrapMessage.ENUM_INJECTION_TARGET_NOT_CREATED, instance);
        }
        this.instances.add(new EnumInstanceContext<Enum>((Enum)Reflections.cast(instance), injector, this.manager.createCreationalContext((Contextual)null)));
    }

    @Override
    public void cleanup() {
        this.instances.clear();
    }
}

