/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import javax.enterprise.event.TransactionPhase;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.Status;
import org.jboss.weld.event.TransactionSynchronizedRunnable;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.transaction.spi.TransactionServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionalObserverMethodImpl<T, X>
extends ObserverMethodImpl<T, X> {
    protected TransactionalObserverMethodImpl(WeldMethod<T, ? super X> observer, RIBean<X> observerBean, TransactionPhase transactionPhase, BeanManagerImpl manager) {
        super(observer, observerBean, manager);
        this.transactionPhase = transactionPhase;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void notify(T event) {
        TransactionServices txs = this.beanManager.getServices().get(TransactionServices.class);
        if (txs != null && txs.isTransactionActive()) {
            this.deferEvent(event);
        } else {
            this.sendEvent(event);
        }
    }

    private void deferEvent(T event) {
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        TransactionSynchronizedRunnable synchronization = null;
        if (this.transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, true);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, false);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, Status.SUCCESS);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, Status.FAILURE);
        }
        this.beanManager.getServices().get(TransactionServices.class).registerSynchronization(synchronization);
    }
}

