/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractWeldAnnotatedHolder;
import org.jboss.weld.serialization.SerializableHolder;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredWeldParameterSerializableHolder<T, X>
extends AbstractWeldAnnotatedHolder<X>
implements SerializableHolder<WeldParameter<T, X>> {
    private static final long serialVersionUID = -2947624534504847812L;
    private final int position;
    private final MethodSignature methodSignature;
    private final ConstructorSignature constructorSignature;
    private transient WeldParameter<T, X> parameter;

    public DiscoveredWeldParameterSerializableHolder(WeldParameter<T, X> parameter) {
        super(parameter.getDeclaringType().getJavaClass());
        this.parameter = parameter;
        this.position = parameter.getPosition();
        if (parameter.getDeclaringWeldCallable() instanceof WeldMethod) {
            this.methodSignature = ((WeldMethod)parameter.getDeclaringWeldCallable()).getSignature();
            this.constructorSignature = null;
        } else if (parameter.getDeclaringWeldCallable() instanceof WeldConstructor) {
            this.methodSignature = null;
            this.constructorSignature = ((WeldConstructor)parameter.getDeclaringWeldCallable()).getSignature();
        } else {
            throw new IllegalStateException(BeanMessage.IP_NOT_CONSTRUCTOR_OR_METHOD, parameter);
        }
    }

    @Override
    public WeldParameter<T, X> get() {
        return this.parameter;
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.parameter = this.getWeldParameter();
        if (this.parameter == null) {
            throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_PARAMETER_ON_DESERIALIZATION, this.getDeclaringWeldClass(), this.methodSignature, this.position);
        }
    }

    protected WeldParameter<T, X> getWeldParameter() {
        if (this.methodSignature != null) {
            WeldMethod method = this.getDeclaringWeldClass().getDeclaredWeldMethod(this.methodSignature);
            if (method.getParameters().size() > this.position) {
                return (WeldParameter)Reflections.cast(method.getWeldParameters().get(this.position));
            }
            throw new IllegalStateException(BeanMessage.PARAM_NOT_IN_PARAM_LIST, this.position, method.getParameters());
        }
        if (this.constructorSignature != null) {
            WeldConstructor constructor = this.getDeclaringWeldClass().getDeclaredWeldConstructor(this.constructorSignature);
            if (constructor.getParameters().size() > this.position) {
                return (WeldParameter)Reflections.cast(constructor.getWeldParameters().get(this.position));
            }
            throw new IllegalStateException(BeanMessage.PARAM_NOT_IN_PARAM_LIST, this.position, constructor.getParameters());
        }
        throw new IllegalStateException(BeanMessage.CANNOT_READ_OBJECT, new Object[0]);
    }
}

