/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Requires;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Veto;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPointImpl;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.injection.attributes.SpecialParameterInjectionPoint;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.WeldCallable;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.Enabled;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beans {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);

    public static boolean isPassivatingScope(Bean<?> bean, BeanManagerImpl manager) {
        if (bean == null) {
            return false;
        }
        return manager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isPassivating();
    }

    public static boolean isPassivationCapableBean(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableBean();
        }
        return Reflections.isSerializable(bean.getBeanClass());
    }

    public static boolean isPassivationCapableDependency(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableDependency();
        }
        if (Container.instance().services().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal()) {
            return true;
        }
        return bean.getScope().equals(Dependent.class) && Beans.isPassivationCapableBean(bean);
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static List<Set<FieldInjectionPoint<?, ?>>> getFieldInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        ArrayList injectableFieldsList = new ArrayList();
        for (WeldClass<?> t = type; t != null && !t.getJavaClass().equals(Object.class); t = t.getWeldSuperclass()) {
            ArraySet fields = new ArraySet();
            injectableFieldsList.add(0, fields);
            for (WeldField<?, ?> annotatedField : t.getDeclaredWeldFields(Inject.class)) {
                if (annotatedField.isStatic()) continue;
                Beans.addFieldInjectionPoint(annotatedField, fields, declaringBean, manager);
            }
            fields.trimToSize();
        }
        return injectableFieldsList;
    }

    public static <T extends WeldInjectionPoint<?, ?>> Set<T> flattenInjectionPoints(List<? extends Set<T>> fieldInjectionPoints) {
        ArraySet<T> injectionPoints = new ArraySet<T>();
        for (Set<T> i : fieldInjectionPoints) {
            injectionPoints.addAll(i);
        }
        return injectionPoints.trimToSize();
    }

    public static <T> List<WeldMethod<?, ? super T>> getPostConstructMethods(WeldClass<T> type) {
        WeldClass<T> t = type;
        ArrayList methods = new ArrayList();
        while (!t.getJavaClass().equals(Object.class)) {
            Collection declaredMethods = (Collection)Reflections.cast(t.getDeclaredWeldMethods(PostConstruct.class));
            log.trace(BeanMessage.FOUND_POST_CONSTRUCT_METHODS, declaredMethods, type);
            if (declaredMethods.size() > 1) {
                throw new DefinitionException(UtilMessage.TOO_MANY_POST_CONSTRUCT_METHODS, type);
            }
            if (declaredMethods.size() == 1) {
                WeldMethod method = (WeldMethod)declaredMethods.iterator().next();
                log.trace(BeanMessage.FOUND_ONE_POST_CONSTRUCT_METHOD, method, type);
                methods.add(0, method);
            }
            t = t.getWeldSuperclass();
        }
        return methods;
    }

    public static <T> List<WeldMethod<?, ? super T>> getObserverMethods(WeldClass<T> type) {
        ArrayList observerMethods = new ArrayList();
        SetMultimap<MethodSignature, Package> seenMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Package>>(){

            @Override
            public Set<Package> get() {
                return new HashSet<Package>();
            }
        });
        for (WeldClass<T> t = type; t != null && !t.getJavaClass().equals(Object.class); t = t.getWeldSuperclass()) {
            for (WeldMethod<?, T> method : t.getDeclaredWeldMethods()) {
                if (!Beans.isOverridden(method, seenMethods) && !method.getWeldParameters(Observes.class).isEmpty()) {
                    observerMethods.add(method);
                }
                seenMethods.put(method.getSignature(), method.getPackage());
            }
        }
        return observerMethods;
    }

    public static <T> List<WeldMethod<?, ? super T>> getPreDestroyMethods(WeldClass<T> type) {
        WeldClass<T> t = type;
        ArrayList methods = new ArrayList();
        while (!t.getJavaClass().equals(Object.class)) {
            Collection declaredMethods = (Collection)Reflections.cast(t.getDeclaredWeldMethods(PreDestroy.class));
            log.trace(BeanMessage.FOUND_PRE_DESTROY_METHODS, declaredMethods, type);
            if (declaredMethods.size() > 1) {
                throw new DefinitionException(UtilMessage.TOO_MANY_PRE_DESTROY_METHODS, type);
            }
            if (declaredMethods.size() == 1) {
                WeldMethod method = (WeldMethod)declaredMethods.iterator().next();
                log.trace(BeanMessage.FOUND_ONE_PRE_DESTROY_METHOD, method, type);
                methods.add(0, method);
            }
            t = t.getWeldSuperclass();
        }
        return methods;
    }

    public static List<WeldMethod<?, ?>> getInterceptableMethods(WeldClass<?> type) {
        ArrayList annotatedMethods = new ArrayList();
        for (WeldMethod<?, ?> annotatedMethod : type.getWeldMethods()) {
            InterceptionType interceptionType;
            boolean businessMethod = !annotatedMethod.isStatic() && !annotatedMethod.isAnnotationPresent(Inject.class) && !((Method)annotatedMethod.getJavaMember()).isBridge();
            if (!businessMethod) continue;
            Iterator<InterceptionType> i$ = InterceptionTypeRegistry.getSupportedInterceptionTypes().iterator();
            while (i$.hasNext() && (businessMethod = !annotatedMethod.isAnnotationPresent(InterceptionTypeRegistry.getAnnotationClass(interceptionType = i$.next())))) {
            }
            if (!businessMethod) continue;
            annotatedMethods.add(annotatedMethod);
        }
        return annotatedMethods;
    }

    public static Set<WeldInjectionPoint<?, ?>> getEjbInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(EjbInjectionServices.class)) {
            Class<? extends Annotation> ejbAnnotationType = manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS;
            ArraySet ejbInjectionPoints = new ArraySet();
            for (WeldField<?, ?> field : type.getWeldFields(ejbAnnotationType)) {
                ejbInjectionPoints.add(FieldInjectionPoint.of(manager.createInjectionPoint(field, declaringBean), manager));
            }
            return ejbInjectionPoints.trimToSize();
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getPersistenceContextInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            ArraySet jpaInjectionPoints = new ArraySet();
            Class<? extends Annotation> persistenceContextAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            for (WeldField<?, ?> field : type.getWeldFields(persistenceContextAnnotationType)) {
                jpaInjectionPoints.add(FieldInjectionPoint.of(manager.createInjectionPoint(field, declaringBean), manager));
            }
            return jpaInjectionPoints.trimToSize();
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getPersistenceUnitInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            ArraySet jpaInjectionPoints = new ArraySet();
            Class<? extends Annotation> persistenceUnitAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_UNIT_ANNOTATION_CLASS;
            for (WeldField<?, ?> field : type.getWeldFields(persistenceUnitAnnotationType)) {
                jpaInjectionPoints.add(FieldInjectionPoint.of(manager.createInjectionPoint(field, declaringBean), manager));
            }
            return jpaInjectionPoints.trimToSize();
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getResourceInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(ResourceInjectionServices.class)) {
            Class<? extends Annotation> resourceAnnotationType = manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS;
            ArraySet resourceInjectionPoints = new ArraySet();
            for (WeldField<?, ?> field : type.getWeldFields(resourceAnnotationType)) {
                resourceInjectionPoints.add(FieldInjectionPoint.of(manager.createInjectionPoint(field, declaringBean), manager));
            }
            return resourceInjectionPoints.trimToSize();
        }
        return Collections.emptySet();
    }

    public static List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        ArrayList initializerMethodsList = new ArrayList();
        SetMultimap<MethodSignature, Package> seenMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Package>>(){

            @Override
            public Set<Package> get() {
                return new HashSet<Package>();
            }
        });
        for (WeldClass<?> t = type; t != null && !t.getJavaClass().equals(Object.class); t = t.getWeldSuperclass()) {
            ArraySet initializerMethods = new ArraySet();
            initializerMethodsList.add(0, initializerMethods);
            for (WeldMethod<?, ?> method : t.getDeclaredWeldMethods()) {
                if (method.isAnnotationPresent(Inject.class) && !method.isStatic()) {
                    if (method.getAnnotation(Produces.class) != null) {
                        throw new DefinitionException(UtilMessage.INITIALIZER_CANNOT_BE_PRODUCER, method, type);
                    }
                    if (method.getWeldParameters(Disposes.class).size() > 0) {
                        throw new DefinitionException(UtilMessage.INITIALIZER_CANNOT_BE_DISPOSAL_METHOD, method, type);
                    }
                    if (method.getWeldParameters(Observes.class).size() > 0) {
                        throw new DefinitionException(EventMessage.INVALID_INITIALIZER, method);
                    }
                    if (method.isGeneric()) {
                        throw new DefinitionException(UtilMessage.INITIALIZER_METHOD_IS_GENERIC, method, type);
                    }
                    if (!Beans.isOverridden(method, seenMethods)) {
                        MethodInjectionPoint<?, ?> initializerMethod = MethodInjectionPoint.of(method, declaringBean, manager);
                        initializerMethods.add(initializerMethod);
                    }
                }
                seenMethods.put(method.getSignature(), method.getPackage());
            }
            initializerMethods.trimToSize();
        }
        return initializerMethodsList;
    }

    private static boolean isOverridden(WeldMethod<?, ?> method, Multimap<MethodSignature, Package> seenMethods) {
        if (method.isPrivate()) {
            return false;
        }
        if (method.isPackagePrivate() && seenMethods.containsKey(method.getSignature())) {
            return seenMethods.get(method.getSignature()).contains(method.getPackage());
        }
        return seenMethods.containsKey(method.getSignature());
    }

    public static <X> List<ParameterInjectionPoint<?, X>> getParameterInjectionPoints(WeldCallable<?, X, ?> callable, Bean<?> declaringBean, BeanManagerImpl manager) {
        ArrayList parameters = new ArrayList();
        for (WeldParameter<?, X> parameter : callable.getWeldParameters()) {
            if (Beans.isSpecialParameter(parameter)) {
                parameters.add(SpecialParameterInjectionPoint.of(parameter, declaringBean));
                continue;
            }
            parameters.add(ParameterInjectionPointImpl.of(manager.createInjectionPoint(parameter, declaringBean), manager));
        }
        return parameters;
    }

    public static <X> Set<ParameterInjectionPoint<?, X>> filterOutSpecialParameterInjectionPoints(List<ParameterInjectionPoint<?, X>> injectionPoints) {
        ArraySet filtered = new ArraySet();
        for (ParameterInjectionPoint<?, X> parameter : injectionPoints) {
            if (parameter instanceof SpecialParameterInjectionPoint) continue;
            filtered.add(parameter);
        }
        return filtered.trimToSize();
    }

    public static boolean isSpecialParameter(WeldParameter<?, ?> parameter) {
        return parameter.isAnnotationPresent(Disposes.class) || parameter.isAnnotationPresent(Observes.class);
    }

    public static Set<ParameterInjectionPoint<?, ?>> flattenParameterInjectionPoints(List<Set<MethodInjectionPoint<?, ?>>> methodInjectionPoints) {
        ArraySet injectionPoints = new ArraySet();
        for (Set<MethodInjectionPoint<?, ?>> i : methodInjectionPoints) {
            for (MethodInjectionPoint<?, ?> method : i) {
                for (ParameterInjectionPoint parameter : method.getParameterInjectionPoints()) {
                    injectionPoints.add(parameter);
                }
            }
        }
        return injectionPoints.trimToSize();
    }

    private static void addFieldInjectionPoint(WeldField<?, ?> annotatedField, Set<FieldInjectionPoint<?, ?>> injectableFields, Bean<?> declaringBean, BeanManagerImpl manager) {
        if (!annotatedField.isAnnotationPresent(Produces.class)) {
            if (annotatedField.isFinal()) {
                throw new DefinitionException(UtilMessage.QUALIFIER_ON_FINAL_FIELD, annotatedField);
            }
            FieldInjectionPoint<?, ?> fieldInjectionPoint = FieldInjectionPoint.of(manager.createInjectionPoint(annotatedField, declaringBean), manager);
            injectableFields.add(fieldInjectionPoint);
        }
    }

    public static boolean containsAllQualifiers(Set<Annotation> requiredQualifiers, Set<Annotation> qualifiers, BeanManagerImpl beanManager) {
        for (Annotation requiredQualifier : requiredQualifiers) {
            QualifierModel<? extends Annotation> qualifierModel = beanManager.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(requiredQualifier.annotationType());
            boolean matchFound = false;
            for (Annotation qualifier : qualifiers) {
                if (!qualifierModel.isEqual(requiredQualifier, qualifier)) continue;
                matchFound = true;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllInterceptionBindings(Set<Annotation> expectedBindings, Set<Annotation> existingBindings, BeanManagerImpl manager) {
        for (Annotation binding : expectedBindings) {
            InterceptorBindingModel<? extends Annotation> bindingType = manager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(binding.annotationType());
            boolean matchFound = false;
            for (Annotation otherBinding : existingBindings) {
                if (!bindingType.isEqual(binding, otherBinding)) continue;
                matchFound = true;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static boolean findInterceptorBindingConflicts(BeanManagerImpl manager, Set<Annotation> bindings) {
        HashMap<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation binding : bindings) {
            if (foundAnnotations.containsKey(binding.annotationType())) {
                InterceptorBindingModel<? extends Annotation> bindingType = manager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(binding.annotationType());
                if (bindingType.isEqual(binding, (Annotation)foundAnnotations.get(binding.annotationType()), false)) continue;
                return true;
            }
            foundAnnotations.put(binding.annotationType(), binding);
        }
        return false;
    }

    public static <T extends Bean<?>> Set<T> removeDisabledAndSpecializedBeans(Set<T> beans, BeanManagerImpl beanManager) {
        if (beans.size() == 0) {
            return beans;
        }
        HashSet<Bean> result = new HashSet<Bean>();
        for (Bean bean : beans) {
            if (!Beans.isBeanEnabled(bean, beanManager.getEnabled()) || Beans.isSpecialized(bean, beans, beanManager) || Beans.isSuppressedBySpecialization(bean, beanManager)) continue;
            result.add(bean);
        }
        return result;
    }

    public static boolean isBeanEnabled(Bean<?> bean, Enabled enabled) {
        if (bean.isAlternative()) {
            if (enabled.getAlternativeClass(bean.getBeanClass()) != null) {
                return true;
            }
            for (Class<Annotation> stereotype : bean.getStereotypes()) {
                if (enabled.getAlternativeStereotype(stereotype) == null) continue;
                return true;
            }
        } else {
            if (bean instanceof DecoratorImpl) {
                return enabled.getDecorator(bean.getBeanClass()) != null;
            }
            if (bean instanceof InterceptorImpl) {
                return enabled.getInterceptor(bean.getBeanClass()) != null;
            }
            return true;
        }
        return false;
    }

    public static boolean isAlternativePresent(Set<Bean<?>> beans) {
        for (Bean<?> bean : beans) {
            if (!bean.isAlternative()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlternative(WeldAnnotated<?, ?> annotated, MergedStereotypes<?, ?> mergedStereotypes) {
        return annotated.isAnnotationPresent(Alternative.class) || mergedStereotypes.isAlternative();
    }

    public static boolean isNullable(WeldAnnotated<?, ?> annotated) {
        return !annotated.isPrimitive();
    }

    public static <T extends Bean<?>> boolean isSpecialized(T bean, BeanManagerImpl beanManager) {
        BeansClosure closure = BeansClosure.getClosure(beanManager);
        return closure.isSpecialized(bean);
    }

    public static <T extends Bean<?>> boolean isSpecialized(T bean, Set<T> beans, BeanManagerImpl beanManager) {
        BeansClosure closure = BeansClosure.getClosure(beanManager);
        Bean<?> specializedBean = closure.getSpecialized(bean);
        return specializedBean != null && beans.contains(specializedBean);
    }

    public static boolean isSuppressedBySpecialization(Bean<?> bean, BeanManagerImpl manager) {
        BeansClosure closure;
        return bean instanceof AbstractReceiverBean && (closure = BeansClosure.getClosure(manager)).isSpecialized(((AbstractReceiverBean)Reflections.cast(bean)).getDeclaringBean());
    }

    public static <T> ConstructorInjectionPoint<T> getBeanConstructor(Bean<T> declaringBean, WeldClass<T> type, BeanManagerImpl manager) {
        ConstructorInjectionPoint<T> constructor = null;
        Collection<WeldConstructor<T>> initializerAnnotatedConstructors = type.getWeldConstructors(Inject.class);
        log.trace(BeanMessage.FOUND_INJECTABLE_CONSTRUCTORS, initializerAnnotatedConstructors, type);
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException(UtilMessage.AMBIGUOUS_CONSTRUCTOR, type, initializerAnnotatedConstructors);
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            constructor = ConstructorInjectionPoint.of(initializerAnnotatedConstructors.iterator().next(), declaringBean, manager);
            log.trace(BeanMessage.FOUND_ONE_INJECTABLE_CONSTRUCTOR, constructor, type);
        } else if (type.getNoArgsWeldConstructor() != null) {
            constructor = ConstructorInjectionPoint.of(type.getNoArgsWeldConstructor(), declaringBean, manager);
            log.trace(BeanMessage.FOUND_DEFAULT_CONSTRUCTOR, constructor, type);
        }
        if (constructor == null) {
            throw new DefinitionException(UtilMessage.UNABLE_TO_FIND_CONSTRUCTOR, type);
        }
        return constructor;
    }

    public static <T> void injectEEFields(T beanInstance, BeanManagerImpl manager, Iterable<WeldInjectionPoint<?, ?>> ejbInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> resourceInjectionPoints) {
        EjbInjectionServices ejbServices = manager.getServices().get(EjbInjectionServices.class);
        JpaInjectionServices jpaServices = manager.getServices().get(JpaInjectionServices.class);
        ResourceInjectionServices resourceServices = manager.getServices().get(ResourceInjectionServices.class);
        if (ejbServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : ejbInjectionPoints) {
                Object ejbInstance = ejbServices.resolveEjb(injectionPoint);
                injectionPoint.inject(beanInstance, ejbInstance);
            }
        }
        if (jpaServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : persistenceContextInjectionPoints) {
                EntityManager pcInstance = jpaServices.resolvePersistenceContext(injectionPoint);
                injectionPoint.inject(beanInstance, pcInstance);
            }
            for (WeldInjectionPoint<?, ?> injectionPoint : persistenceUnitInjectionPoints) {
                EntityManagerFactory puInstance = jpaServices.resolvePersistenceUnit(injectionPoint);
                injectionPoint.inject(beanInstance, puInstance);
            }
        }
        if (resourceServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : resourceInjectionPoints) {
                Object resourceInstance = resourceServices.resolveResource(injectionPoint);
                injectionPoint.inject(beanInstance, resourceInstance);
            }
        }
    }

    public static Object resolveEEResource(BeanManagerImpl manager, WeldInjectionPoint<?, ?> injectionPoint) {
        EjbInjectionServices ejbServices = manager.getServices().get(EjbInjectionServices.class);
        JpaInjectionServices jpaServices = manager.getServices().get(JpaInjectionServices.class);
        ResourceInjectionServices resourceServices = manager.getServices().get(ResourceInjectionServices.class);
        if (ejbServices != null) {
            Class<? extends Annotation> ejbAnnotationType = manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS;
            if (injectionPoint.getAnnotated().isAnnotationPresent(ejbAnnotationType)) {
                return ejbServices.resolveEjb(injectionPoint);
            }
        }
        if (jpaServices != null) {
            PersistenceApiAbstraction persistenceApiAbstraction = manager.getServices().get(PersistenceApiAbstraction.class);
            Class<? extends Annotation> persistenceUnitAnnotationType = persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS;
            if (injectionPoint.getAnnotated().isAnnotationPresent(persistenceUnitAnnotationType)) {
                return jpaServices.resolvePersistenceUnit(injectionPoint);
            }
            Class<? extends Annotation> persistenceContextAnnotationType = persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            if (injectionPoint.getAnnotated().isAnnotationPresent(persistenceContextAnnotationType)) {
                return jpaServices.resolvePersistenceContext(injectionPoint);
            }
        }
        if (resourceServices != null) {
            Class<? extends Annotation> resourceAnnotationType = manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS;
            if (injectionPoint.getAnnotated().isAnnotationPresent(resourceAnnotationType)) {
                return resourceServices.resolveResource(injectionPoint);
            }
        }
        return null;
    }

    public static Type getDeclaredBeanType(Class<?> clazz) {
        Type[] actualTypeArguments = Reflections.getActualTypeArguments(clazz);
        if (actualTypeArguments.length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    public static <T> void injectBoundFields(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends FieldInjectionPoint<?, ?>> injectableFields) {
        for (FieldInjectionPoint<T, T> fieldInjectionPoint : injectableFields) {
            fieldInjectionPoint.inject(instance, manager, creationalContext);
        }
    }

    public static <T> void injectFieldsAndInitializers(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager, List<? extends Iterable<? extends FieldInjectionPoint<?, ?>>> injectableFields, List<? extends Iterable<? extends MethodInjectionPoint<?, ?>>> initializerMethods) {
        if (injectableFields.size() != initializerMethods.size()) {
            throw new IllegalArgumentException(UtilMessage.INVALID_QUANTITY_INJECTABLE_FIELDS_AND_INITIALIZER_METHODS, injectableFields, initializerMethods);
        }
        for (int i = 0; i < injectableFields.size(); ++i) {
            Beans.injectBoundFields(instance, ctx, beanManager, injectableFields.get(i));
            Beans.callInitializers(instance, ctx, beanManager, initializerMethods.get(i));
        }
    }

    public static <T> void callInitializers(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends MethodInjectionPoint<?, ?>> initializerMethods) {
        for (MethodInjectionPoint<T, T> methodInjectionPoint : initializerMethods) {
            methodInjectionPoint.invoke(instance, manager, creationalContext, CreationException.class);
        }
    }

    public static <T> boolean isInterceptor(WeldClass<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Interceptor.class);
    }

    public static <T> boolean isDecorator(WeldClass<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(javax.decorator.Decorator.class);
    }

    public static Annotation[] mergeInQualifiers(Annotation[] qualifiers, Annotation[] newQualifiers) {
        if (qualifiers == null || newQualifiers == null) {
            return Reflections.EMPTY_ANNOTATIONS;
        }
        return Beans.mergeInQualifiers(Arrays.asList(qualifiers), newQualifiers).toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public static Set<Annotation> mergeInQualifiers(Collection<Annotation> qualifiers, Annotation[] newQualifiers) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            result.addAll(qualifiers);
        }
        if (newQualifiers != null && newQualifiers.length > 0) {
            MetaAnnotationStore store = Container.instance().services().get(MetaAnnotationStore.class);
            HashSet<Annotation> checkedNewQualifiers = new HashSet<Annotation>();
            for (Annotation qualifier : newQualifiers) {
                if (!store.getBindingTypeModel(qualifier.annotationType()).isValid()) {
                    throw new IllegalArgumentException(UtilMessage.ANNOTATION_NOT_QUALIFIER, qualifier);
                }
                if (checkedNewQualifiers.contains(qualifier)) {
                    throw new IllegalArgumentException(UtilMessage.REDUNDANT_QUALIFIER, qualifier, Arrays.asList(newQualifiers));
                }
                checkedNewQualifiers.add(qualifier);
            }
            result.addAll(checkedNewQualifiers);
        }
        return result;
    }

    public static InjectionPoint getDelegateInjectionPoint(Decorator<?> decorator) {
        if (decorator instanceof DecoratorImpl) {
            return ((DecoratorImpl)decorator).getDelegateInjectionPoint();
        }
        for (InjectionPoint injectionPoint : decorator.getInjectionPoints()) {
            if (!injectionPoint.isDelegate()) continue;
            return injectionPoint;
        }
        return null;
    }

    public static Set<Type> getTypes(WeldAnnotated<?, ?> annotated) {
        Set<Type> types = new HashSet<Type>();
        if (annotated.getJavaClass().isArray() || annotated.getJavaClass().isPrimitive()) {
            types.add(annotated.getJavaClass());
            types.add((Type)((Object)Object.class));
            return types;
        }
        if (annotated.isAnnotationPresent(Typed.class)) {
            types = new ArraySet<Type>(Beans.getTypedTypes(Reflections.buildTypeMap(annotated.getTypeClosure()), annotated.getJavaClass(), annotated.getAnnotation(Typed.class)));
        } else {
            if (annotated.getJavaClass().isInterface()) {
                types.add((Type)((Object)Object.class));
            }
            types.addAll(annotated.getTypeClosure());
        }
        return types;
    }

    public static <T> Set<Type> getTypes(WeldAnnotated<T, ?> annotated, EjbDescriptor<T> ejbDescriptor) {
        HashSet<Type> types = new HashSet<Type>();
        LinkedHashMap typeMap = new LinkedHashMap();
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : ejbDescriptor.getLocalBusinessInterfaces()) {
            typeMap.putAll(new HierarchyDiscovery(businessInterfaceDescriptor.getInterface()).getTypeMap());
        }
        if (annotated.isAnnotationPresent(Typed.class)) {
            types.addAll(Beans.getTypedTypes(typeMap, annotated.getJavaClass(), annotated.getAnnotation(Typed.class)));
        } else {
            typeMap.put(Object.class, (Type)((Object)Object.class));
            types.addAll(typeMap.values());
        }
        return types;
    }

    public static Set<Type> getTypedTypes(Map<Class<?>, Type> typeClosure, Class<?> rawType, Typed typed) {
        HashSet<Type> types = new HashSet<Type>();
        for (Class<?> specifiedClass : typed.value()) {
            Type tmp = typeClosure.get(specifiedClass);
            if (tmp == null) {
                throw new DefinitionException(BeanMessage.TYPED_CLASS_NOT_IN_HIERARCHY, specifiedClass.getName(), rawType);
            }
            types.add(tmp);
        }
        types.add((Type)((Object)Object.class));
        return types;
    }

    public static boolean isTypeManagedBeanOrDecoratorOrInterceptor(WeldClass<?> clazz) {
        Class javaClass = clazz.getJavaClass();
        return !javaClass.isEnum() && !Extension.class.isAssignableFrom(clazz.getJavaClass()) && !clazz.isAnonymousClass() && (!clazz.isMemberClass() || clazz.isStatic()) && !Reflections.isParamerterizedTypeWithWildcard(javaClass) && Beans.hasSimpleCdiConstructor(clazz);
    }

    public static boolean hasSimpleCdiConstructor(WeldClass<?> type) {
        return type.getNoArgsWeldConstructor() != null || type.getWeldConstructors(Inject.class).size() > 0;
    }

    public static boolean isVetoed(AnnotatedType<?> type) {
        Class<?> javaClass = type.getJavaClass();
        if (type.isAnnotationPresent(Veto.class)) {
            return true;
        }
        if (Beans.isRequirementMissing(type.getAnnotation(Requires.class), javaClass.getClassLoader())) {
            return true;
        }
        if (javaClass.getPackage() != null) {
            if (javaClass.getPackage().isAnnotationPresent(Veto.class)) {
                return true;
            }
            if (Beans.isRequirementMissing(javaClass.getPackage().getAnnotation(Requires.class), javaClass.getClassLoader())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRequirementMissing(Requires requires, ClassLoader classLoader) {
        if (requires == null) {
            return false;
        }
        ClassLoaderResourceLoader loader = new ClassLoaderResourceLoader(classLoader);
        for (String className : requires.value()) {
            if (Reflections.isClassLoadable(className, loader)) continue;
            return true;
        }
        return false;
    }

    public static String createBeanAttributesId(BeanAttributes<?> attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append(attributes.getName());
        builder.append(",");
        builder.append(attributes.getScope().getName());
        builder.append(",");
        builder.append(attributes.isAlternative());
        builder.append(",");
        builder.append(attributes.isNullable());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(attributes.getQualifiers()));
        builder.append(Beans.createTypeCollectionId(attributes.getStereotypes()));
        builder.append(Beans.createTypeCollectionId(attributes.getTypes()));
        return builder.toString();
    }

    public static String createTypeCollectionId(Collection<? extends Type> types) {
        StringBuilder builder = new StringBuilder();
        ArrayList<? extends Type> sortedTypes = new ArrayList<Type>(types);
        Collections.sort(sortedTypes, TypeComparator.INSTANCE);
        builder.append("[");
        Iterator iterator = sortedTypes.iterator();
        while (iterator.hasNext()) {
            builder.append(Beans.createTypeId((Type)iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String createTypeId(Type type) {
        if (type instanceof Class) {
            return ((Class)Reflections.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(Beans.createTypeId(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                builder.append(Beans.createTypeId(parameterizedType.getActualTypeArguments()[i]));
                if (i == parameterizedType.getActualTypeArguments().length - 1) continue;
                builder.append(",");
            }
            builder.append(">");
            return builder.toString();
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)Reflections.cast(type)).getName();
        }
        if (type instanceof GenericArrayType) {
            return Beans.createTypeId(((GenericArrayType)Reflections.cast(type)).getGenericComponentType());
        }
        throw new java.lang.IllegalArgumentException("Unknown type " + type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeComparator
    implements Comparator<Type> {
        private static final TypeComparator INSTANCE = new TypeComparator();

        private TypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return Beans.createTypeId(o1).compareTo(Beans.createTypeId(o2));
        }
    }
}

