/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeansClosure {
    private static final Map<BeanManagerImpl, BeansClosure> closureMap = new HashMap<BeanManagerImpl, BeansClosure>();
    private final Map<Bean<?>, Bean<?>> specialized = new ConcurrentHashMap();
    private final Map<BeanDeployerEnvironment, Object> envs = new ConcurrentHashMap<BeanDeployerEnvironment, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeansClosure getClosure(BeanManagerImpl beanManager) {
        BeansClosure closure = closureMap.get(beanManager);
        if (closure == null) {
            Map<BeanManagerImpl, BeansClosure> map = closureMap;
            synchronized (map) {
                if (!closureMap.containsKey(beanManager)) {
                    closure = new BeansClosure();
                    for (Iterable<BeanManagerImpl> beanManagers : BeanManagers.getAccessibleClosure(beanManager)) {
                        for (BeanManagerImpl accessibleBeanManager : beanManagers) {
                            closureMap.put(accessibleBeanManager, closure);
                        }
                    }
                }
            }
        }
        return closure;
    }

    public static void removeClosure(BeanManagerImpl beanManager) {
        BeansClosure closure = closureMap.remove(beanManager);
        if (closure != null) {
            closure.destroy();
        }
    }

    public static void removeAccessibleClosure(BeanManagerImpl beanManager) {
        for (Iterable<BeanManagerImpl> beanManagers : BeanManagers.getAccessibleClosure(beanManager)) {
            for (BeanManagerImpl accessibleBeanManager : beanManagers) {
                BeansClosure.removeClosure(accessibleBeanManager);
            }
        }
    }

    public void addSpecialized(Bean<?> target, Bean<?> override) {
        this.specialized.put(target, override);
    }

    public void removeSpecialized(Bean<?> target) {
        this.specialized.remove(target);
    }

    public void addEnvironment(BeanDeployerEnvironment environment) {
        this.envs.put(environment, Object.class);
    }

    public void clear() {
        this.envs.clear();
    }

    private void destroy() {
        this.specialized.clear();
    }

    @Deprecated
    public Map getSpecialized() {
        return Collections.unmodifiableMap(this.specialized);
    }

    public Bean<?> getSpecialized(Bean<?> bean) {
        return this.specialized.get(bean);
    }

    public boolean isSpecialized(Bean<?> bean) {
        return this.getSpecialized(bean) != null;
    }

    public Bean<?> mostSpecialized(Bean<?> bean) {
        Bean<?> most = bean;
        while (most != null) {
            Bean<?> temp = most;
            most = this.specialized.get(bean);
            bean = temp;
        }
        return bean;
    }

    public boolean isEJB(WeldClass<?> clazz) {
        for (BeanDeployerEnvironment bde : this.envs.keySet()) {
            EjbDescriptors ed = bde.getEjbDescriptors();
            if (!ed.contains(clazz.getJavaClass())) continue;
            return true;
        }
        return false;
    }

    public Bean<?> getClassBean(WeldClass<?> clazz) {
        for (BeanDeployerEnvironment bde : this.envs.keySet()) {
            AbstractClassBean<?> classBean = bde.getClassBean(clazz);
            if (classBean == null) continue;
            return classBean;
        }
        return null;
    }

    public ProducerMethod<?, ?> getProducerMethod(WeldMethod<?, ?> superClassMethod) {
        for (BeanDeployerEnvironment bde : this.envs.keySet()) {
            ProducerMethod<?, ?> pm = bde.getProducerMethod(superClassMethod);
            if (pm == null) continue;
            return pm;
        }
        return null;
    }
}

