/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractContext
implements AlterableContext {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final boolean multithreaded;
    private final ServiceRegistry serviceRegistry;

    public AbstractContext(boolean multithreaded) {
        this.multithreaded = multithreaded;
        this.serviceRegistry = Container.instance().services();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="False positive from FindBugs")
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            return null;
        }
        if (contextual == null) {
            throw new IllegalArgumentException(ContextMessage.CONTEXTUAL_IS_NULL, new Object[0]);
        }
        String id = this.getId(contextual);
        ContextualInstance beanInstance = beanStore.get(id);
        if (beanInstance != null) {
            return beanInstance.getInstance();
        }
        if (creationalContext != null) {
            LockedBean lock = null;
            try {
                T instance;
                if (this.multithreaded) {
                    lock = beanStore.lock(id);
                    beanInstance = beanStore.get(id);
                    if (beanInstance != null) {
                        Object t = beanInstance.getInstance();
                        return t;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableContextualInstanceImpl<Contextual<T>, T>(contextual, instance, creationalContext, this.serviceRegistry.get(ContextualStore.class));
                    beanStore.put(id, beanInstance);
                }
                T t = instance;
                return t;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (contextual == null) {
            throw new IllegalArgumentException(ContextMessage.CONTEXTUAL_IS_NULL, new Object[0]);
        }
        if (this.getBeanStore() == null) {
            throw new IllegalStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        String id = this.getId(contextual);
        ContextualInstance beanInstance = this.getBeanStore().remove(id);
        if (beanInstance != null) {
            RequestScopedBeanCache.invalidate();
            this.destroyContextualInstance(beanInstance);
        }
    }

    private <T> ContextualInstance<T> getContextualInstance(String id) {
        if (this.getBeanStore() == null) {
            throw new IllegalStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        return this.getBeanStore().get(id);
    }

    private <T> void destroyContextualInstance(ContextualInstance<T> instance) {
        instance.getContextual().destroy(instance.getInstance(), instance.getCreationalContext());
        log.trace(ContextMessage.CONTEXTUAL_INSTANCE_REMOVED, instance, this);
    }

    protected void destroy() {
        log.trace(ContextMessage.CONTEXT_CLEARED, this);
        if (this.getBeanStore() == null) {
            throw new IllegalStateException(ContextMessage.NO_BEAN_STORE_AVAILABLE, this);
        }
        for (String id : this.getBeanStore()) {
            this.destroyContextualInstance(this.getContextualInstance(id));
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    public void cleanup() {
        if (this.getBeanStore() != null) {
            this.getBeanStore().clear();
        }
    }

    protected static <T> Contextual<T> getContextual(String id) {
        return Container.instance().services().get(ContextualStore.class).getContextual(id);
    }

    protected String getId(Contextual<?> contextual) {
        return this.serviceRegistry.get(ContextualStore.class).putIfAbsent(contextual);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

