/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Preconditions;

public class ApiAbstraction {
    private static final Class<DummyAnnotation> DUMMY_ANNOTATION = DummyAnnotation.class;
    private static final Class<Dummy> DUMMY_CLASS = Dummy.class;
    private ResourceLoader resourceLoader;

    public ApiAbstraction(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Class<? extends Annotation> annotationTypeForName(String name) {
        try {
            return this.resourceLoader.classForName(name);
        }
        catch (ResourceLoadingException cnfe) {
            return DUMMY_ANNOTATION;
        }
    }

    protected Class<?> classForName(String name) {
        try {
            return this.resourceLoader.classForName(name);
        }
        catch (ResourceLoadingException cnfe) {
            return DUMMY_CLASS;
        }
    }

    protected Object enumValue(Class<?> clazz, String memberName) {
        Preconditions.checkArgumentNotNull(memberName, "memberName");
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(UtilMessage.CLASS_NOT_ENUM, clazz);
        }
        try {
            Field field = clazz.getField(memberName);
            return field.get(null);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (java.lang.IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static enum DummyEnum {
        DUMMY_VALUE;

    }

    public static interface Dummy {
    }

    public static @interface DummyAnnotation {
    }
}

