/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.bean.builtin.ee.ServletContextBean;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationContextActivator;
import org.jboss.weld.servlet.SessionHolder;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class HttpContextLifecycle
implements Service {
    private static final String HTTP_SESSION = "org.jboss.weld." + HttpSession.class.getName();
    private static final String INCLUDE_HEADER = "javax.servlet.include.request_uri";
    private static final String REQUEST_DESTROYED = HttpContextLifecycle.class.getName() + ".request.destroyed";
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private HttpSessionContext sessionContextCache;
    private HttpRequestContext requestContextCache;
    private volatile boolean conversationActivationEnabled;
    private final BeanManagerImpl beanManager;
    private final ConversationContextActivator conversationContextActivator;

    public HttpContextLifecycle(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.conversationContextActivator = new ConversationContextActivator(beanManager);
        this.conversationActivationEnabled = true;
    }

    private HttpSessionContext getSessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)this.beanManager.instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    public HttpRequestContext getRequestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)this.beanManager.instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    public void contextInitialized(ServletContext ctx) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)ctx, InitializedLiteral.APPLICATION);
    }

    public void contextDestroyed(ServletContext ctx) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)ctx, DestroyedLiteral.APPLICATION);
    }

    public void sessionCreated(HttpSession session) {
        SessionHolder.sessionCreated(session);
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)session, InitializedLiteral.SESSION);
    }

    public void sessionDestroyed(HttpSession session) {
        boolean destroyed = this.getSessionContext().destroy(session);
        SessionHolder.clear();
        RequestScopedBeanCache.endRequest();
        if (destroyed) {
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)session, DestroyedLiteral.SESSION);
        } else if (this.getRequestContext() instanceof HttpRequestContextImpl) {
            HttpServletRequest request = ((HttpRequestContextImpl)Reflections.cast(this.getRequestContext())).getHttpServletRequest();
            request.setAttribute(HTTP_SESSION, (Object)session);
        }
    }

    public void requestInitialized(HttpServletRequest request, ServletContext ctx) {
        if (this.isIncludedRequest(request)) {
            return;
        }
        log.trace(ServletMessage.REQUEST_INITIALIZED, request);
        SessionHolder.requestInitialized(request);
        ServletContextBean.setServletContext(ctx);
        this.getRequestContext().associate(request);
        this.getSessionContext().associate(request);
        if (this.conversationActivationEnabled) {
            this.conversationContextActivator.associateConversationContext(request);
        }
        this.getRequestContext().activate();
        this.getSessionContext().activate();
        try {
            if (this.conversationActivationEnabled) {
                this.conversationContextActivator.activateConversationContext(request);
            }
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, InitializedLiteral.REQUEST);
        }
        catch (RuntimeException e) {
            this.requestDestroyed(request);
            request.setAttribute(REQUEST_DESTROYED, (Object)Boolean.TRUE);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(HttpServletRequest request) {
        if (this.isIncludedRequest(request) || this.isRequestDestroyed(request)) {
            return;
        }
        log.trace(REQUEST_DESTROYED, (Object)request);
        try {
            this.conversationContextActivator.deactivateConversationContext(request);
            this.getRequestContext().invalidate();
            this.getRequestContext().deactivate();
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, DestroyedLiteral.REQUEST);
            this.getSessionContext().deactivate();
            if (!this.getSessionContext().isValid()) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent(request.getAttribute(HTTP_SESSION), DestroyedLiteral.SESSION);
            }
        }
        finally {
            this.getRequestContext().dissociate(request);
            this.getSessionContext().dissociate(request);
            this.conversationContextActivator.disassociateConversationContext(request);
            SessionHolder.clear();
            ServletContextBean.cleanup();
        }
    }

    public boolean isConversationActivationEnabled() {
        return this.conversationActivationEnabled;
    }

    public void setConversationActivationEnabled(boolean conversationActivationEnabled) {
        this.conversationActivationEnabled = conversationActivationEnabled;
    }

    private boolean isIncludedRequest(HttpServletRequest request) {
        return request.getAttribute(INCLUDE_HEADER) != null;
    }

    private boolean isRequestDestroyed(HttpServletRequest request) {
        return request.getAttribute(REQUEST_DESTROYED) != null;
    }

    @Override
    public void cleanup() {
    }
}

