/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer.ejb;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.weld.bean.proxy.EnterpriseProxyFactory;
import org.jboss.weld.bean.proxy.EnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.InjectionPointPropagatingEnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.NewInstanceAction;

public class SessionBeanProxyInstantiator<T>
implements Instantiator<T> {
    private final Class<T> proxyClass;
    private final SessionBean<T> bean;

    public SessionBeanProxyInstantiator(EnhancedAnnotatedType<T> type, SessionBean<T> bean) {
        this.bean = bean;
        this.proxyClass = new EnterpriseProxyFactory(type.getJavaClass(), bean).getProxyClass();
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        try {
            T instance = AccessController.doPrivileged(NewInstanceAction.of(this.proxyClass));
            ctx.push(instance);
            ProxyFactory.setBeanInstance(instance, this.createEnterpriseTargetBeanInstance(), this.bean);
            return instance;
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InstantiationException) {
                throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, e.getCause(), this);
            }
            if (e.getCause() instanceof IllegalAccessException) {
                throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, e.getCause(), this);
            }
            throw new WeldException(e.getCause());
        }
        catch (Exception e) {
            throw new CreationException(BeanMessage.EJB_NOT_FOUND, (Throwable)e, this.proxyClass);
        }
    }

    protected EnterpriseTargetBeanInstance createEnterpriseTargetBeanInstance() {
        return new InjectionPointPropagatingEnterpriseTargetBeanInstance(this.bean.getBeanClass(), new EnterpriseBeanProxyMethodHandler<T>(this.bean), this.bean.getBeanManager());
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }

    public SessionBean<T> getBean() {
        return this.bean;
    }

    @Override
    public Constructor<T> getConstructor() {
        return null;
    }
}

