/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterceptionTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptionTypeRegistry.class);
    private static final Map<InterceptionType, Class<? extends Annotation>> INTERCEPTOR_ANNOTATION_CLASSES;

    private InterceptionTypeRegistry() {
    }

    public static Collection<InterceptionType> getSupportedInterceptionTypes() {
        return INTERCEPTOR_ANNOTATION_CLASSES.keySet();
    }

    public static boolean isSupported(InterceptionType interceptionType) {
        return INTERCEPTOR_ANNOTATION_CLASSES.containsKey((Object)interceptionType);
    }

    public static Class<? extends Annotation> getAnnotationClass(InterceptionType interceptionType) {
        return INTERCEPTOR_ANNOTATION_CLASSES.get((Object)interceptionType);
    }

    static {
        HashMap interceptionAnnotationClasses = new HashMap();
        for (InterceptionType interceptionType : InterceptionType.values()) {
            try {
                interceptionAnnotationClasses.put(interceptionType, InterceptionTypeRegistry.class.getClassLoader().loadClass(interceptionType.annotationClassName()));
            }
            catch (Exception e) {
                LOG.warn("Class '{}' not found, interception based on it is not enabled", (Object)interceptionType.annotationClassName());
            }
        }
        INTERCEPTOR_ANNOTATION_CLASSES = Collections.unmodifiableMap(interceptionAnnotationClasses);
    }
}

