/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;
import org.slf4j.cal10n.LocLogger;

public class BeanMethods {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);

    private BeanMethods() {
    }

    private static <T, R> R getMethods(EnhancedAnnotatedType<T> type, MethodListBuilder<T, R> builder) {
        Collection<EnhancedAnnotatedMethod<?, T>> methods = builder.getAllMethods(type);
        for (Class clazz = type.getJavaClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            builder.levelStart(clazz);
            for (EnhancedAnnotatedMethod<?, T> method : methods) {
                if (!((Method)method.getJavaMember()).getDeclaringClass().equals(clazz)) continue;
                builder.processMethod(method);
            }
            builder.levelFinish();
        }
        return builder.create();
    }

    public static <T> List<AnnotatedMethod<? super T>> getPostConstructMethods(final EnhancedAnnotatedType<T> type) {
        return (List)BeanMethods.getMethods(type, new AbstractLifecycleEventCallbackMethodListBuilder<T>(){

            @Override
            public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type2) {
                return type2.getEnhancedMethods(PostConstruct.class);
            }

            @Override
            protected void duplicateMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
                throw new DefinitionException(UtilMessage.TOO_MANY_POST_CONSTRUCT_METHODS, type);
            }

            @Override
            protected EnhancedAnnotatedMethod<?, ? super T> processLevelResult(EnhancedAnnotatedMethod<?, ? super T> method) {
                log.trace(BeanMessage.FOUND_ONE_POST_CONSTRUCT_METHOD, method, type);
                return method;
            }
        });
    }

    public static <T> List<AnnotatedMethod<? super T>> getPreDestroyMethods(final EnhancedAnnotatedType<T> type) {
        return (List)BeanMethods.getMethods(type, new AbstractLifecycleEventCallbackMethodListBuilder<T>(){

            @Override
            public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type2) {
                return type2.getEnhancedMethods(PreDestroy.class);
            }

            @Override
            protected void duplicateMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
                throw new DefinitionException(UtilMessage.TOO_MANY_PRE_DESTROY_METHODS, type);
            }

            @Override
            protected EnhancedAnnotatedMethod<?, ? super T> processLevelResult(EnhancedAnnotatedMethod<?, ? super T> method) {
                log.trace(BeanMessage.FOUND_PRE_DESTROY_METHODS, method, type);
                return method;
            }
        });
    }

    public static <T> List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods(Bean<?> declaringBean, EnhancedAnnotatedType<T> type, BeanManagerImpl manager) {
        return (List)BeanMethods.getMethods(type, new InitializerMethodListBuilder<T>(type, declaringBean, manager));
    }

    public static <T> Collection<EnhancedAnnotatedMethod<?, ? super T>> getObserverMethods(EnhancedAnnotatedType<T> type) {
        return type.getEnhancedMethodsWithAnnotatedParameters(Observes.class);
    }

    private static class InitializerMethodListBuilder<T>
    implements MethodListBuilder<T, List<Set<MethodInjectionPoint<?, ?>>>> {
        private final List<Set<MethodInjectionPoint<?, ?>>> result = new ArrayList();
        private Set<MethodInjectionPoint<?, ?>> currentLevel = null;
        private final EnhancedAnnotatedType<T> type;
        private final BeanManagerImpl manager;
        private final Bean<?> declaringBean;

        public InitializerMethodListBuilder(EnhancedAnnotatedType<T> type, Bean<?> declaringBean, BeanManagerImpl manager) {
            this.type = type;
            this.manager = manager;
            this.declaringBean = declaringBean;
        }

        @Override
        public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type) {
            return type.getEnhancedMethods(Inject.class);
        }

        @Override
        public void levelStart(Class<? super T> clazz) {
            this.currentLevel = new ArraySet();
        }

        @Override
        public void processMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
            if (method.isAnnotationPresent(Inject.class)) {
                if (method.getAnnotation(Produces.class) != null) {
                    throw new DefinitionException(UtilMessage.INITIALIZER_CANNOT_BE_PRODUCER, method, this.type);
                }
                if (method.getEnhancedParameters(Disposes.class).size() > 0) {
                    throw new DefinitionException(UtilMessage.INITIALIZER_CANNOT_BE_DISPOSAL_METHOD, method, this.type);
                }
                if (method.getEnhancedParameters(Observes.class).size() > 0) {
                    throw new DefinitionException(EventMessage.INVALID_INITIALIZER, method);
                }
                if (method.isGeneric()) {
                    throw new DefinitionException(UtilMessage.INITIALIZER_METHOD_IS_GENERIC, method, this.type);
                }
                if (!method.isStatic()) {
                    this.currentLevel.add(InjectionPointFactory.instance().createMethodInjectionPoint(method, this.declaringBean, this.type.getJavaClass(), false, this.manager));
                }
            }
        }

        @Override
        public void levelFinish() {
            this.result.add(this.currentLevel);
        }

        @Override
        public List<Set<MethodInjectionPoint<?, ?>>> create() {
            Collections.reverse(this.result);
            return WeldCollections.immutableList(this.result);
        }
    }

    private static abstract class AbstractLifecycleEventCallbackMethodListBuilder<T>
    implements MethodListBuilder<T, List<AnnotatedMethod<? super T>>> {
        protected List<AnnotatedMethod<? super T>> result = new ArrayList<AnnotatedMethod<? super T>>();
        protected EnhancedAnnotatedMethod<?, ? super T> foundMethod = null;

        private AbstractLifecycleEventCallbackMethodListBuilder() {
        }

        @Override
        public void levelStart(Class<? super T> clazz) {
            this.foundMethod = null;
        }

        @Override
        public void processMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
            if (this.isValidTargetClassLifecycleInterceptorMethod(method)) {
                if (this.foundMethod != null) {
                    this.duplicateMethod(method);
                }
                this.foundMethod = method;
            }
        }

        private boolean isValidTargetClassLifecycleInterceptorMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
            return Void.TYPE.equals(method.getJavaClass()) && method.getParameterTypesAsArray().length == 0;
        }

        @Override
        public void levelFinish() {
            if (this.foundMethod != null) {
                this.result.add(this.processLevelResult(this.foundMethod).slim());
            }
        }

        @Override
        public List<AnnotatedMethod<? super T>> create() {
            Collections.reverse(this.result);
            return WeldCollections.immutableList(this.result);
        }

        protected abstract void duplicateMethod(EnhancedAnnotatedMethod<?, ? super T> var1);

        protected abstract EnhancedAnnotatedMethod<?, ? super T> processLevelResult(EnhancedAnnotatedMethod<?, ? super T> var1);
    }

    private static interface MethodListBuilder<T, R> {
        public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> var1);

        public void levelStart(Class<? super T> var1);

        public void processMethod(EnhancedAnnotatedMethod<?, ? super T> var1);

        public void levelFinish();

        public R create();
    }
}

