/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.ContainerState;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.MessageConveyorFactory;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;

public class Container {
    public static final String CONTEXT_ID_KEY = "WELD_CONTEXT_ID_KEY";
    public static final ThreadLocal<String> currentId = new ThreadLocal();
    private static Singleton<Container> instance = SingletonProvider.instance().create(Container.class);
    private final String contextId;
    private final BeanManagerImpl deploymentManager;
    private final Map<String, BeanManagerImpl> managers;
    private final Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives;
    private final ServiceRegistry deploymentServices;
    private ContainerState state = ContainerState.STOPPED;

    public static Container instance() {
        return instance.get("STATIC_INSTANCE");
    }

    public static boolean available() {
        String id = "STATIC_INSTANCE";
        return instance.isSet(id) && instance.get(id) != null && instance.get(id).getState().isAvailable();
    }

    public static Container instance(String contextId) {
        return instance.get(contextId);
    }

    public static Container instance(BeanManagerImpl manager) {
        return Container.instance(manager.getContextId());
    }

    public static Container instance(AnnotatedTypeIdentifier identifier) {
        return Container.instance(identifier.getContextId());
    }

    public static boolean available(String contextId) {
        boolean b = instance.isSet(contextId) && Container.instance(contextId) != null && Container.instance(contextId).getState().isAvailable();
        return b;
    }

    public static void initialize(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container instance = new Container("STATIC_INSTANCE", deploymentManager, deploymentServices);
        Container.instance.set("STATIC_INSTANCE", instance);
    }

    public static void initialize(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container instance = new Container(contextId, deploymentManager, deploymentServices);
        Container.instance.set(contextId, instance);
    }

    public Container(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this.deploymentManager = deploymentManager;
        this.managers = new ConcurrentHashMap<String, BeanManagerImpl>();
        this.managers.put(deploymentManager.getId(), deploymentManager);
        this.beanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanManagerImpl>();
        this.deploymentServices = deploymentServices;
        this.contextId = contextId;
    }

    public Container(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this.deploymentManager = deploymentManager;
        this.managers = new ConcurrentHashMap<String, BeanManagerImpl>();
        this.managers.put(deploymentManager.getId(), deploymentManager);
        this.beanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanManagerImpl>();
        this.deploymentServices = deploymentServices;
        this.contextId = "STATIC_INSTANCE";
    }

    public void cleanup() {
        this.managers.clear();
        for (BeanManagerImpl beanManager : this.beanDeploymentArchives.values()) {
            beanManager.cleanup();
        }
        this.beanDeploymentArchives.clear();
        this.deploymentServices.cleanup();
        this.deploymentManager.cleanup();
        LoggerFactory.cleanup();
        MessageConveyorFactory.cleanup();
        instance.clear(this.contextId);
    }

    public BeanManagerImpl deploymentManager() {
        return this.deploymentManager;
    }

    public Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public BeanManagerImpl activityManager(String key) {
        return this.managers.get(key);
    }

    public String addActivity(BeanManagerImpl manager) {
        String id = manager.getId();
        if (manager.getId() == null) {
            throw new IllegalArgumentException(BeanManagerMessage.NULL_BEAN_MANAGER_ID, manager);
        }
        this.managers.put(id, manager);
        return id;
    }

    public ServiceRegistry services() {
        return this.deploymentServices;
    }

    public void putBeanDeployments(BeanDeploymentArchiveMapping bdaMapping) {
        for (Map.Entry entry : bdaMapping.getBdaToBeanManagerMap().entrySet()) {
            this.beanDeploymentArchives.put((BeanDeploymentArchive)entry.getKey(), (BeanManagerImpl)entry.getValue());
            this.addActivity((BeanManagerImpl)entry.getValue());
        }
    }

    public ContainerState getState() {
        return this.state;
    }

    public void setState(ContainerState state) {
        this.state = state;
    }
}

