/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.AbstractConversationContext;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class ConversationContextActivator {
    private static final String NO_CID = "nocid";
    private static final String CONVERSATION_PROPAGATION = "conversationPropagation";
    private static final String CONVERSATION_PROPAGATION_NONE = "none";
    private static final String CONTEXT_ACTIVATED_IN_REQUEST = ConversationContextActivator.class.getName() + "CONTEXT_ACTIVATED_IN_REQUEST";
    private final BeanManagerImpl beanManager;
    private HttpConversationContext httpConversationContextCache;
    private HttpRequestContext requestContextCache;

    protected ConversationContextActivator(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
    }

    private HttpConversationContext httpConversationContext() {
        if (this.httpConversationContextCache == null) {
            this.httpConversationContextCache = (HttpConversationContext)this.beanManager.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.httpConversationContextCache;
    }

    private HttpRequestContext getRequestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)this.beanManager.instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    public void startConversationContext(HttpServletRequest request) {
        this.associateConversationContext(request);
        this.activateConversationContext(request);
    }

    public void stopConversationContext(HttpServletRequest request) {
        this.deactivateConversationContext(request);
    }

    protected void activateConversationContext(HttpServletRequest request) {
        HttpConversationContext conversationContext = this.httpConversationContext();
        String cid = ConversationContextActivator.getConversationId(request, this.httpConversationContext());
        ConversationLogger.LOG.resumingConversation(cid);
        if (!this.isContextActivatedInRequest(request)) {
            this.setContextActivatedInRequest(request);
            conversationContext.activate(cid);
            if (cid == null) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, InitializedLiteral.CONVERSATION);
            }
        } else {
            conversationContext.dissociate(request);
            conversationContext.associate(request);
            conversationContext.activate(cid);
        }
    }

    protected void associateConversationContext(HttpServletRequest request) {
        this.httpConversationContext().associate(request);
    }

    private static String getConversationId(HttpServletRequest request, ConversationContext conversationContext) {
        if (request.getParameter(NO_CID) != null) {
            return null;
        }
        if (CONVERSATION_PROPAGATION_NONE.equals(request.getParameter(CONVERSATION_PROPAGATION))) {
            return null;
        }
        String cidName = conversationContext.getParameterName();
        String cid = request.getParameter(cidName);
        ConversationLogger.LOG.foundConversationFromRequest(cid);
        return cid;
    }

    private void setContextActivatedInRequest(HttpServletRequest request) {
        request.setAttribute(CONTEXT_ACTIVATED_IN_REQUEST, (Object)true);
    }

    private boolean isContextActivatedInRequest(HttpServletRequest request) {
        Object result = request.getAttribute(CONTEXT_ACTIVATED_IN_REQUEST);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    protected void deactivateConversationContext(HttpServletRequest request) {
        HttpConversationContext conversationContext = this.httpConversationContext();
        if (conversationContext.isActive()) {
            boolean isTransient = conversationContext.getCurrentConversation().isTransient();
            if (ConversationLogger.LOG.isTraceEnabled()) {
                if (isTransient) {
                    ConversationLogger.LOG.cleaningUpTransientConversation();
                } else {
                    ConversationLogger.LOG.cleaningUpConversation(conversationContext.getCurrentConversation().getId());
                }
            }
            conversationContext.invalidate();
            conversationContext.deactivate();
            if (isTransient) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, DestroyedLiteral.CONVERSATION);
            }
        }
    }

    protected void disassociateConversationContext(HttpServletRequest request) {
        this.httpConversationContext().dissociate(request);
    }

    public void sessionCreated(HttpSession session) {
        HttpRequestContext requestContext = this.getRequestContext();
        HttpConversationContext httpConversationContext = this.httpConversationContext();
        if (requestContext instanceof HttpRequestContextImpl && httpConversationContext instanceof AbstractConversationContext) {
            HttpRequestContextImpl httpRequestContext = (HttpRequestContextImpl)requestContext;
            HttpServletRequest request = httpRequestContext.getHttpServletRequest();
            AbstractConversationContext abstractConversationContext = (AbstractConversationContext)((Object)httpConversationContext);
            abstractConversationContext.sessionCreated(request);
        }
    }
}

