/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class CdiInterceptorFactory<T>
implements InterceptorFactory<T> {
    private final ClassMetadata<T> classMetadata;
    private final Interceptor<T> interceptor;

    public CdiInterceptorFactory(ClassMetadata<T> classMetadata, Interceptor<T> interceptor) {
        this.classMetadata = classMetadata;
        this.interceptor = interceptor;
    }

    @Override
    public ClassMetadata<T> getClassMetadata() {
        return this.classMetadata;
    }

    @Override
    public T create(CreationalContext<T> ctx, BeanManagerImpl manager) {
        return Reflections.cast(manager.getReference(this.interceptor, this.interceptor.getBeanClass(), ctx, true));
    }

    public Interceptor<T> getInterceptor() {
        return this.interceptor;
    }

    public int hashCode() {
        return this.interceptor.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CdiInterceptorFactory) {
            CdiInterceptorFactory that = (CdiInterceptorFactory)obj;
            return this.interceptor.equals(that.interceptor);
        }
        return false;
    }

    public String toString() {
        return "CdiInterceptorFactory [interceptor=" + this.interceptor + "]";
    }
}

