/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.se.discovery.AbstractWeldSEDeployment;
import org.jboss.weld.environment.se.discovery.WeldSEBeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.url.BeanArchiveBuilder;
import org.jboss.weld.environment.se.discovery.url.URLScanner;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public abstract class DiscoveryStrategy {
    private final ResourceLoader resourceLoader;
    private final Bootstrap bootstrap;
    private Collection<BeanArchiveBuilder> builders;
    public static final String[] RESOURCES = new String[]{"META-INF/beans.xml"};
    private final Set<WeldSEBeanDeploymentArchive> deploymentArchives = new HashSet<WeldSEBeanDeploymentArchive>();

    public DiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
    }

    public Set<WeldSEBeanDeploymentArchive> discoverArchives() {
        this.builders = new URLScanner(this.resourceLoader, this.bootstrap, AbstractWeldSEDeployment.RESOURCES).scan();
        this.initialize();
        block5: for (BeanArchiveBuilder builder : this.builders) {
            BeansXml beansXml = builder.parseBeansXml();
            switch (beansXml.getBeanDiscoveryMode()) {
                case ALL: {
                    this.addToArchives(this.processAllDiscovery(builder));
                    continue block5;
                }
                case ANNOTATED: {
                    this.addToArchives(this.processAnnotatedDiscovery(builder));
                    continue block5;
                }
                case NONE: {
                    this.addToArchives(this.processNoneDiscovery(builder));
                    continue block5;
                }
            }
            WeldSELogger.LOG.undefinedBeanDiscoveryValue((Object)beansXml.getBeanDiscoveryMode());
        }
        this.assignVisibility(this.deploymentArchives);
        return this.deploymentArchives;
    }

    private void assignVisibility(Set<WeldSEBeanDeploymentArchive> deploymentArchives) {
        for (WeldSEBeanDeploymentArchive archive : deploymentArchives) {
            archive.setBeanDeploymentArchives(deploymentArchives);
        }
    }

    public Collection<BeanArchiveBuilder> getBuilders() {
        return this.builders;
    }

    protected void addToArchives(WeldSEBeanDeploymentArchive bda) {
        if (bda != null) {
            this.deploymentArchives.add(bda);
        }
    }

    protected void initialize() {
    }

    protected WeldSEBeanDeploymentArchive processNoneDiscovery(BeanArchiveBuilder builder) {
        return null;
    }

    protected WeldSEBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        return null;
    }

    protected WeldSEBeanDeploymentArchive processAllDiscovery(BeanArchiveBuilder builder) {
        WeldSEBeanDeploymentArchive bda = builder.build();
        return bda;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

