/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.se.discovery.url.BeanArchiveBuilder;
import org.jboss.weld.environment.se.discovery.url.URLHandler;
import org.jboss.weld.environment.se.discovery.url.WeldSEResourceLoader;
import org.jboss.weld.environment.se.logging.WeldSELogger;

public class FileSystemURLHandler
implements URLHandler {
    private static final Logger log = Logger.getLogger(FileSystemURLHandler.class);
    private static final String UNEXPECTED_CLASSLOADER_MESSAGE = "could not invoke JNLPClassLoader#getJarFile(URL) on context class loader, expecting Web Start class loader";
    protected static final String CLASS_FILE_EXTENSION = ".class";
    private static final String BEANS_XML = "beans.xml";
    private final List<String> discoveredClasses = new ArrayList<String>();
    private URL discoveredBeansXmlUrl = null;
    private final Bootstrap bootstrap;

    public FileSystemURLHandler(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public BeanArchiveBuilder handle(String urlPath) {
        try {
            File file;
            log.tracev("scanning: {0}", (Object)urlPath);
            if (urlPath.startsWith("http:") || urlPath.startsWith("https:")) {
                ClassLoader jnlpClassLoader = WeldSEResourceLoader.getClassLoader();
                try {
                    Method m = jnlpClassLoader.getClass().getMethod("getJarFile", URL.class);
                    ZipFile jarFile = (ZipFile)m.invoke((Object)jnlpClassLoader, new URL(urlPath));
                    urlPath = jarFile.getName();
                }
                catch (MalformedURLException mue) {
                    WeldSELogger.LOG.couldNotReadEntries(urlPath, mue);
                }
                catch (NoSuchMethodException nsme) {
                    WeldSELogger.LOG.unexpectedClassLoader(nsme);
                }
                catch (IllegalArgumentException iarge) {
                    WeldSELogger.LOG.unexpectedClassLoader(iarge);
                }
                catch (InvocationTargetException ite) {
                    WeldSELogger.LOG.jnlpClassLoaderInternalException(ite);
                }
                catch (Exception iacce) {
                    WeldSELogger.LOG.jnlpClassLoaderInvocationException(iacce);
                }
            }
            if ((file = new File(urlPath)).isDirectory()) {
                this.handleDirectory(file, null);
            } else {
                this.handleArchiveByFile(file);
            }
        }
        catch (IOException ioe) {
            log.warn((Object)"could not read entries", ioe);
        }
        return this.createBeanArchiveBuilder();
    }

    protected void handleArchiveByFile(File file) throws IOException {
        try {
            log.tracev("archive: {0}", (Object)file);
            String archiveUrl = "jar:" + file.toURI().toURL().toExternalForm() + "!/";
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this.addToDiscovered(name, new URL(archiveUrl + name));
            }
            zip.close();
        }
        catch (ZipException e) {
            throw WeldSELogger.LOG.cannotHandleFile(file, e);
        }
    }

    protected void handleDirectory(File dir, String path) {
        log.tracev("handling directory: {0}", (Object)dir);
        File[] files = dir.listFiles();
        assert (files != null);
        for (File child : files) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            try {
                this.addToDiscovered(newPath, child.toURI().toURL());
            }
            catch (MalformedURLException e) {
                WeldSELogger.LOG.errorLoadingFile(newPath);
            }
        }
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    protected void addToDiscovered(String name, URL url) {
        if (name.endsWith(CLASS_FILE_EXTENSION)) {
            this.discoveredClasses.add(FileSystemURLHandler.filenameToClassname(name));
        } else if (name.endsWith(BEANS_XML)) {
            if (this.discoveredBeansXmlUrl == null) {
                this.discoveredBeansXmlUrl = url;
            } else {
                WeldSELogger.LOG.tooManyBeansXml();
            }
        }
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(CLASS_FILE_EXTENSION)).replace('/', '.').replace('\\', '.');
    }

    public List<String> getDiscoveredClasses() {
        return this.discoveredClasses;
    }

    public URL getDiscoveredBeansXmlUrl() {
        return this.discoveredBeansXmlUrl;
    }

    protected BeanArchiveBuilder createBeanArchiveBuilder() {
        return new BeanArchiveBuilder(null, null, this.discoveredClasses, this.discoveredBeansXmlUrl, this.bootstrap);
    }
}

