/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.environment.se.discovery.WeldSEBeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.url.BeanArchiveBuilder;
import org.jboss.weld.environment.se.discovery.url.DiscoveryStrategy;
import org.jboss.weld.resources.spi.ResourceLoader;

public class JandexEnabledDiscoveryStrategy
extends DiscoveryStrategy {
    private final Set<DotName> beanDefiningAnnotations = new HashSet<DotName>();
    private CompositeIndex cindex;

    public JandexEnabledDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, TypeDiscoveryConfiguration typeDiscoveryConfiguration) {
        super(resourceLoader, bootstrap);
        Set<Class<? extends Annotation>> knownBeanDefiningAnnotations = typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations();
        for (Class<? extends Annotation> annotation : knownBeanDefiningAnnotations) {
            DotName annotationDotName = DotName.createSimple((String)annotation.getName());
            this.beanDefiningAnnotations.add(annotationDotName);
        }
    }

    @Override
    protected void initialize() {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (BeanArchiveBuilder builder : this.getBuilders()) {
            IndexView index = (IndexView)builder.getIndex();
            indexes.add(index);
        }
        this.cindex = CompositeIndex.create(indexes);
    }

    @Override
    protected WeldSEBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            ClassInfo cinfo = this.cindex.getClassByName(DotName.createSimple((String)className));
            if (this.containsBeanDefiningAnnotation(cinfo.annotations().keySet())) continue;
            classIterator.remove();
        }
        WeldSEBeanDeploymentArchive bda = builder.build();
        return bda;
    }

    private boolean containsBeanDefiningAnnotation(Set<DotName> annotations) {
        for (DotName name : annotations) {
            if (!this.beanDefiningAnnotations.contains(name)) continue;
            return true;
        }
        return false;
    }

    public CompositeIndex getCompositeJandexIndex() {
        return this.cindex;
    }
}

