/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class SEReflections {
    private SEReflections() {
    }

    public static boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> requiredAnnotation) {
        for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if ((clazz == javaClass || requiredAnnotation.isAnnotationPresent(Inherited.class)) && SEReflections.containsAnnotations(clazz.getAnnotations(), requiredAnnotation)) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!SEReflections.containsAnnotations(field.getAnnotations(), requiredAnnotation)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (SEReflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!SEReflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (SEReflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!SEReflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean containsAnnotations(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation) {
        return SEReflections.containsAnnotation(annotations, requiredAnnotation, true);
    }

    private static boolean containsAnnotation(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (requiredAnnotation.equals(annotationType)) {
                return true;
            }
            if (!checkMetaAnnotations || !SEReflections.containsAnnotation(annotationType.getAnnotations(), requiredAnnotation, false)) continue;
            return true;
        }
        return false;
    }

    public static <T> T newInstance(ResourceLoader loader, String className, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            Class clazz = (Class)Reflections.cast(loader.classForName(className));
            Constructor<T> constructor = SEReflections.findConstructor(clazz, parameters);
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate " + className + " using parameters: " + Arrays.toString(parameters), e);
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz, Object ... parameters) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            boolean match = true;
            for (int i = 0; i < parameters.length; ++i) {
                if (constructor.getParameterTypes()[i].isAssignableFrom(parameters[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return (Constructor)Reflections.cast(constructor);
        }
        throw new IllegalStateException("Unable to find constructor for of " + clazz + " accepting parameters: " + Arrays.toString(parameters));
    }
}

