/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.literal.DestroyedLiteral;

public class ShutdownManager {
    private static Logger log = Logger.getLogger(ShutdownManager.class);
    private boolean hasShutdownBeenCalled = false;
    private final Bootstrap bootstrap;
    private final BeanManager beanManager;

    ShutdownManager(Bootstrap bootstrap, BeanManager beanManager) {
        this.bootstrap = bootstrap;
        this.beanManager = beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            if (!this.hasShutdownBeenCalled) {
                this.hasShutdownBeenCalled = true;
                try {
                    this.beanManager.fireEvent(new Object(), DestroyedLiteral.APPLICATION);
                }
                finally {
                    this.bootstrap.shutdown();
                }
            } else {
                log.debug("Skipping spurious call to shutdown");
                log.tracev("Spurious call to shutdown from: {0}", Thread.currentThread().getStackTrace());
            }
        }
    }
}

