/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.logging;

import javax.enterprise.inject.UnsatisfiedResolutionException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.resources.spi.ClassFileInfoException;

@MessageLogger(projectCode="WELD-SE-")
public interface WeldSELogger
extends BasicLogger {
    public static final WeldSELogger LOG = Logger.getMessageLogger(WeldSELogger.class, "WELD-SE");
    public static final String CATCHING_MARKER = "Catching";
    public static final String WELD_PROJECT_CODE = "WELD-SE-";

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1, value="Catching")
    public void catchingDebug(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Could not read resource with name: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotReadResource(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Could not read entries, method JNLPClassLoader#getJarFile(URL) did not return a valid URL for the path {0}", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotReadEntries(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader, expecting Web Start class loader", format=Message.Format.MESSAGE_FORMAT)
    public void unexpectedClassLoader(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="JNLPClassLoader#getJarFile(URL) threw exception", format=Message.Format.MESSAGE_FORMAT)
    public void jnlpClassLoaderInternalException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader", format=Message.Format.MESSAGE_FORMAT)
    public void jnlpClassLoaderInvocationException(@Cause Throwable var1);

    @Message(id=7, value="Error handling file {0}", format=Message.Format.MESSAGE_FORMAT)
    public RuntimeException cannotHandleFile(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Error loading file {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorLoadingFile(Object var1);

    @Message(id=9, value="There is more than one beans.xml in the archive", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException tooManyBeansXml();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Could not open the stream on the url {0} when adding to the jandex index.", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotOpenStreamForURL(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Could not close the stream on the url {0} when adding to the jandex index.", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotCloseStreamForURL(Object var1, @Cause Throwable var2);

    @Message(id=12, value="Unable to load class {0}", format=Message.Format.MESSAGE_FORMAT)
    public ClassFileInfoException unableToLoadClass(Object var1);

    @Message(id=13, value="beans.xml defines unrecognized bean-discovery-mode value: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException undefinedBeanDiscoveryValue(Object var1);

    @Message(id=14, value="bean discovery-mode=\"annotated\" support is disabled. Add org.jboss:jandex to the classpath to enable it.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException annotatedBeanDiscoveryNotSupported();

    @Message(id=15, value="Unable to load annotation: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToLoadAnnotation(Object var1);

    @Message(id=16, value="Missing beans.xml file in META-INF", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException missingBeansXml();

    @Message(id=17, value="Error loading Weld bootstrap, check that Weld is on the classpath", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException errorLoadingWeld();

    @Message(id=18, value="Unable to resolve a bean for {0} with bindings {1}", format=Message.Format.MESSAGE_FORMAT)
    public UnsatisfiedResolutionException unableToResolveBean(Object var1, Object var2);
}

