/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.resolution.QualifierInstance;

public class Bindings {
    private Bindings() {
    }

    public static boolean areQualifiersEquivalent(Annotation qualifier1, Annotation qualifier2, MetaAnnotationStore store) {
        Bindings.checkQualifier(qualifier1, store);
        Bindings.checkQualifier(qualifier2, store);
        QualifierInstance q1 = store.getQualifierInstance(qualifier1);
        QualifierInstance q2 = store.getQualifierInstance(qualifier2);
        return q1.equals(q2);
    }

    public static int getQualifierHashCode(Annotation qualifier, MetaAnnotationStore store) {
        Bindings.checkQualifier(qualifier, store);
        return store.getQualifierInstance(qualifier).hashCode();
    }

    private static void checkQualifier(Annotation qualifier, MetaAnnotationStore store) {
        Preconditions.checkNotNull(qualifier);
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(qualifier.annotationType());
        if (model == null || !model.isValid()) {
            throw BeanManagerLogger.LOG.invalidQualifier(qualifier);
        }
    }

    public static boolean areInterceptorBindingsEquivalent(Annotation qualifier1, Annotation qualifier2, MetaAnnotationStore store) {
        Bindings.checkInterceptorBinding(qualifier1, store);
        Bindings.checkInterceptorBinding(qualifier2, store);
        QualifierInstance q1 = store.getQualifierInstance(qualifier1);
        QualifierInstance q2 = store.getQualifierInstance(qualifier2);
        return q1.equals(q2);
    }

    public static int getInterceptorBindingHashCode(Annotation qualifier, MetaAnnotationStore store) {
        Bindings.checkInterceptorBinding(qualifier, store);
        return store.getQualifierInstance(qualifier).hashCode();
    }

    private static void checkInterceptorBinding(Annotation qualifier, MetaAnnotationStore store) {
        Preconditions.checkNotNull(qualifier);
        InterceptorBindingModel<? extends Annotation> model = store.getInterceptorBindingModel(qualifier.annotationType());
        if (model == null || !model.isValid()) {
            throw BeanManagerLogger.LOG.interceptorResolutionWithNonbindingType(qualifier);
        }
    }
}

