/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.se.discovery.url.BeanArchiveBuilder;
import org.jboss.weld.environment.se.discovery.url.FileSystemURLHandler;
import org.jboss.weld.environment.se.logging.WeldSELogger;

public class JandexEnabledFileSystemURLHandler
extends FileSystemURLHandler {
    private final Indexer indexer = new Indexer();

    public JandexEnabledFileSystemURLHandler(Bootstrap bootstrap) {
        super(bootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIndex(URL url) {
        InputStream fs = null;
        try {
            fs = url.openStream();
            this.indexer.index(fs);
        }
        catch (IOException ex) {
            WeldSELogger.LOG.couldNotOpenStreamForURL(url, ex);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException ex) {
                WeldSELogger.LOG.couldNotCloseStreamForURL(url, ex);
            }
        }
    }

    @Override
    protected void addToDiscovered(String name, URL url) {
        super.addToDiscovered(name, url);
        if (name.endsWith(".class")) {
            this.addToIndex(url);
        }
    }

    @Override
    protected BeanArchiveBuilder createBeanArchiveBuilder() {
        return new BeanArchiveBuilder(null, this.buildJandexIndex(), this.getDiscoveredClasses(), this.getDiscoveredBeansXmlUrl(), this.getBootstrap());
    }

    public Index buildJandexIndex() {
        return this.indexer.complete();
    }
}

