/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.api.helpers.RegistrySingletonProvider;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.se.ShutdownManager;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.discovery.WeldSEBeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.url.DefaultDiscoveryStrategy;
import org.jboss.weld.environment.se.discovery.url.DiscoveryStrategy;
import org.jboss.weld.environment.se.discovery.url.WeldSEResourceLoader;
import org.jboss.weld.environment.se.discovery.url.WeldSEUrlDeployment;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.environment.se.util.SEReflections;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.GetSystemPropertyAction;
import org.jboss.weld.util.reflection.Reflections;

public class Weld {
    private static final String SYSTEM_PROPERTY_STRING = "System property ";
    private static final Logger log = Logger.getLogger(Weld.class);
    private static final String JANDEX_ENABLED_DISCOVERY_STRATEGY_CLASS_NAME = "org.jboss.weld.environment.se.discovery.url.JandexEnabledDiscoveryStrategy";
    private static final String CLASS_FILE_SERVICES_CLASS_NAME = "org.jboss.weld.environment.se.discovery.WeldSEClassFileServices";
    public static final String ARCHIVE_ISOLATION_SYSTEM_PROPERTY = "org.jboss.weld.se.archive.isolation";
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    public static final String JANDEX_INDEX_CLASS_NAME = "org.jboss.jandex.Index";
    private ShutdownManager shutdownManager;
    private Set<Metadata<Extension>> extensions;
    private final String containerId;

    public Weld() {
        this("STATIC_INSTANCE");
    }

    public Weld(String containerId) {
        this.containerId = containerId;
    }

    public void addExtension(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new HashSet<Metadata<Extension>>();
        }
        this.extensions.add(new MetadataImpl<Extension>(extension, "<explicitly-added>"));
    }

    public WeldContainer initialize() {
        CDI11Bootstrap bootstrap;
        WeldSEResourceLoader resourceLoader = new WeldSEResourceLoader();
        if (resourceLoader.getResource("META-INF/beans.xml") == null) {
            throw WeldSELogger.LOG.missingBeansXml();
        }
        try {
            bootstrap = (CDI11Bootstrap)resourceLoader.classForName(BOOTSTRAP_IMPL_CLASS_NAME).newInstance();
        }
        catch (InstantiationException ex) {
            throw WeldSELogger.LOG.errorLoadingWeld();
        }
        catch (IllegalAccessException ex) {
            throw WeldSELogger.LOG.errorLoadingWeld();
        }
        Deployment deployment = this.createDeployment(resourceLoader, bootstrap);
        bootstrap.startContainer(this.containerId, Environments.SE, deployment);
        bootstrap.startInitialization();
        bootstrap.deployBeans();
        bootstrap.validateBeans();
        bootstrap.endInitialization();
        WeldManager manager = bootstrap.getManager(deployment.loadBeanDeploymentArchive(WeldContainer.class));
        this.shutdownManager = new ShutdownManager(bootstrap, manager);
        WeldContainer container = this.getInstanceByType(manager, WeldContainer.class, new Annotation[0]);
        container.event().select(ContainerInitialized.class, InitializedLiteral.APPLICATION).fire(new ContainerInitialized());
        return container;
    }

    private Iterable<Metadata<Extension>> loadExtensions(ClassLoader classLoader, Bootstrap bootstrap) {
        Iterable<Metadata<Extension>> iter = bootstrap.loadExtensions(classLoader);
        if (this.extensions != null) {
            HashSet<Metadata<Extension>> set = new HashSet<Metadata<Extension>>(this.extensions);
            for (Metadata<Extension> ext : iter) {
                set.add(ext);
            }
            return set;
        }
        return iter;
    }

    protected Deployment createDeployment(ResourceLoader resourceLoader, CDI11Bootstrap bootstrap) {
        DiscoveryStrategy strategy;
        Iterable<Metadata<Extension>> loadedExtensions = this.loadExtensions(WeldSEResourceLoader.getClassLoader(), bootstrap);
        TypeDiscoveryConfiguration typeDiscoveryConfiguration = bootstrap.startExtensions(loadedExtensions);
        if (Reflections.isClassLoadable(JANDEX_INDEX_CLASS_NAME, resourceLoader)) {
            strategy = (DiscoveryStrategy)SEReflections.newInstance(resourceLoader, JANDEX_ENABLED_DISCOVERY_STRATEGY_CLASS_NAME, resourceLoader, bootstrap, typeDiscoveryConfiguration);
        } else {
            strategy = new DefaultDiscoveryStrategy(resourceLoader, bootstrap);
            log.debug("For the deployment, DefaultDiscoveryStrategy is used.");
        }
        Set<WeldSEBeanDeploymentArchive> discoveredArchives = strategy.discoverArchives();
        String isolation = AccessController.doPrivileged(new GetSystemPropertyAction(ARCHIVE_ISOLATION_SYSTEM_PROPERTY));
        WeldSEUrlDeployment deployment = null;
        if (isolation != null && Boolean.valueOf(isolation).equals(Boolean.FALSE)) {
            log.debug("System property org.jboss.weld.se.archive.isolation is set to false value, so only one bean archive will be created.");
            WeldSEBeanDeploymentArchive archive = this.mergeToOne(bootstrap, discoveredArchives);
            deployment = new WeldSEUrlDeployment(resourceLoader, bootstrap, Collections.singleton(archive), loadedExtensions);
        } else {
            log.debug("System property org.jboss.weld.se.archive.isolation is on default true value, creating multiple bean archives if needed.");
            deployment = new WeldSEUrlDeployment(resourceLoader, bootstrap, discoveredArchives, loadedExtensions);
        }
        if (strategy.getClass().getName().equals(JANDEX_ENABLED_DISCOVERY_STRATEGY_CLASS_NAME)) {
            ClassFileServices classFileServices = (ClassFileServices)SEReflections.newInstance(resourceLoader, CLASS_FILE_SERVICES_CLASS_NAME, strategy);
            deployment.getServices().add(ClassFileServices.class, classFileServices);
        }
        return deployment;
    }

    private WeldSEBeanDeploymentArchive mergeToOne(CDI11Bootstrap bootstrap, Collection<WeldSEBeanDeploymentArchive> discoveredArchives) {
        HashSet<String> beanClasses = new HashSet<String>();
        HashSet<URL> urls = new HashSet<URL>();
        for (BeanDeploymentArchive beanDeploymentArchive : discoveredArchives) {
            beanClasses.addAll(beanDeploymentArchive.getBeanClasses());
            urls.add(beanDeploymentArchive.getBeansXml().getUrl());
        }
        BeansXml beansXml = bootstrap.parse(urls, true);
        WeldSEBeanDeploymentArchive weldSEBeanDeploymentArchive = new WeldSEBeanDeploymentArchive("main", beanClasses, beansXml);
        return weldSEBeanDeploymentArchive;
    }

    protected <T> T getInstanceByType(BeanManager manager, Class<T> type, Annotation ... bindings) {
        Bean bean = manager.resolve(manager.getBeans(type, bindings));
        if (bean == null) {
            throw WeldSELogger.LOG.unableToResolveBean(type, Arrays.asList(bindings));
        }
        CreationalContext cc = manager.createCreationalContext(bean);
        return type.cast(manager.getReference(bean, type, cc));
    }

    public void shutdown() {
        if (this.shutdownManager != null) {
            this.shutdownManager.shutdown();
        }
    }

    static {
        SingletonProvider.initialize(new RegistrySingletonProvider());
    }
}

