/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.jboss.weld.probe.Resource;

final class IOUtils {
    private static final int DEFAULT_BUFFER = 8192;

    private IOUtils() {
    }

    static String getResourceAsString(String resourceName) {
        StringWriter writer = new StringWriter();
        BufferedReader reader = null;
        try {
            InputStream in = Resource.class.getResourceAsStream(resourceName);
            if (in == null) {
                String string = null;
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            char[] buffer = new char[8192];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            writer.flush();
            String string = writer.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    static boolean writeResource(String resourceName, OutputStream out) {
        InputStream in = Resource.class.getResourceAsStream(resourceName);
        if (in == null) {
            return false;
        }
        try {
            byte[] buffer = new byte[8192];
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                out.write(buffer, 0, n);
            }
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

