package org.jboss.weld.environment.logging;

import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.weld.resources.spi.ClassFileInfoException;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-02-02T10:28:30+0100")
public class CommonLogger_$logger extends DelegatingBasicLogger implements CommonLogger,org.jboss.weld.environment.logging.WeldEnvironmentLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CommonLogger_$logger.class.getName();
    public CommonLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void couldNotReadResource(final Object param1, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, couldNotReadResource$str(), param1);
    }
    private static final String couldNotReadResource = "WELD-ENV-000002: Could not read resource with name: {0}";
    protected String couldNotReadResource$str() {
        return couldNotReadResource;
    }
    @Override
    public final void unexpectedClassLoader(final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, unexpectedClassLoader$str());
    }
    private static final String unexpectedClassLoader = "WELD-ENV-000004: Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader, expecting Web Start class loader";
    protected String unexpectedClassLoader$str() {
        return unexpectedClassLoader;
    }
    @Override
    public final void jnlpClassLoaderInternalException(final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, jnlpClassLoaderInternalException$str());
    }
    private static final String jnlpClassLoaderInternalException = "WELD-ENV-000005: JNLPClassLoader#getJarFile(URL) threw exception";
    protected String jnlpClassLoaderInternalException$str() {
        return jnlpClassLoaderInternalException;
    }
    @Override
    public final void jnlpClassLoaderInvocationException(final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, jnlpClassLoaderInvocationException$str());
    }
    private static final String jnlpClassLoaderInvocationException = "WELD-ENV-000006: Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader";
    protected String jnlpClassLoaderInvocationException$str() {
        return jnlpClassLoaderInvocationException;
    }
    @Override
    public final void cannotHandleFilePath(final Object file, final Object path, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, cannotHandleFilePath$str(), file, path);
    }
    private static final String cannotHandleFilePath = "WELD-ENV-000007: Error handling file path\n  File: {0}\n  Path: {1}";
    protected String cannotHandleFilePath$str() {
        return cannotHandleFilePath;
    }
    @Override
    public final void couldNotOpenStreamForURL(final Object param1, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, couldNotOpenStreamForURL$str(), param1);
    }
    private static final String couldNotOpenStreamForURL = "WELD-ENV-000010: Could not open the stream on the url {0} when adding to the jandex index.";
    protected String couldNotOpenStreamForURL$str() {
        return couldNotOpenStreamForURL;
    }
    @Override
    public final void couldNotCloseStreamForURL(final Object param1, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, couldNotCloseStreamForURL$str(), param1);
    }
    private static final String couldNotCloseStreamForURL = "WELD-ENV-000011: Could not close the stream on the url {0} when adding to the jandex index.";
    protected String couldNotCloseStreamForURL$str() {
        return couldNotCloseStreamForURL;
    }
    private static final String unableToLoadClass = "WELD-ENV-000012: Unable to load class {0}";
    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }
    @Override
    public final ClassFileInfoException unableToLoadClass(final Object param1) {
        final ClassFileInfoException result = new ClassFileInfoException(java.text.MessageFormat.format(unableToLoadClass$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedBeanDiscoveryValue = "WELD-ENV-000013: beans.xml defines unrecognized bean-discovery-mode value: {0}";
    protected String undefinedBeanDiscoveryValue$str() {
        return undefinedBeanDiscoveryValue;
    }
    @Override
    public final IllegalStateException undefinedBeanDiscoveryValue(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(undefinedBeanDiscoveryValue$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void reflectionFallback() {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, reflectionFallback$str());
    }
    private static final String reflectionFallback = "WELD-ENV-000014: Falling back to Java Reflection for bean-discovery-mode=\"annotated\" discovery. Add org.jboss:jandex to the classpath to speed-up startup.";
    protected String reflectionFallback$str() {
        return reflectionFallback;
    }
    private static final String unableToLoadAnnotation = "WELD-ENV-000015: Unable to load annotation: {0}";
    protected String unableToLoadAnnotation$str() {
        return unableToLoadAnnotation;
    }
    @Override
    public final ClassFileInfoException unableToLoadAnnotation(final Object param1) {
        final ClassFileInfoException result = new ClassFileInfoException(java.text.MessageFormat.format(unableToLoadAnnotation$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBeansXml = "WELD-ENV-000016: Missing beans.xml file in META-INF";
    protected String missingBeansXml$str() {
        return missingBeansXml;
    }
    @Override
    public final IllegalStateException missingBeansXml() {
        final IllegalStateException result = new IllegalStateException(missingBeansXml$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResolveBean = "WELD-ENV-000018: Unable to resolve a bean for {0} with bindings {1}";
    protected String unableToResolveBean$str() {
        return unableToResolveBean;
    }
    @Override
    public final UnsatisfiedResolutionException unableToResolveBean(final Object param1, final Object param2) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(java.text.MessageFormat.format(unableToResolveBean$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jandexIndexNotCreated = "WELD-ENV-000019: Jandex index is null in the constructor of class: {0}";
    protected String jandexIndexNotCreated$str() {
        return jandexIndexNotCreated;
    }
    @Override
    public final IllegalStateException jandexIndexNotCreated(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(jandexIndexNotCreated$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void usingJandex() {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, usingJandex$str());
    }
    private static final String usingJandex = "WELD-ENV-000020: Using jandex for bean discovery";
    protected String usingJandex$str() {
        return usingJandex;
    }
    @Override
    public final void archiveIsolationDisabled() {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, archiveIsolationDisabled$str());
    }
    private static final String archiveIsolationDisabled = "WELD-ENV-000023: Archive isolation disabled - only one bean archive will be created";
    protected String archiveIsolationDisabled$str() {
        return archiveIsolationDisabled;
    }
    @Override
    public final void archiveIsolationEnabled() {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, archiveIsolationEnabled$str());
    }
    private static final String archiveIsolationEnabled = "WELD-ENV-000024: Archive isolation enabled - creating multiple isolated bean archives if needed";
    protected String archiveIsolationEnabled$str() {
        return archiveIsolationEnabled;
    }
    private static final String indexForNameNotFound = "WELD-ENV-000025: Index for name: {0} not found.";
    protected String indexForNameNotFound$str() {
        return indexForNameNotFound;
    }
    @Override
    public final ClassFileInfoException indexForNameNotFound(final Object param1) {
        final ClassFileInfoException result = new ClassFileInfoException(java.text.MessageFormat.format(indexForNameNotFound$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiate = "WELD-ENV-000026: Unable to instantiate {0} using parameters: {1}.";
    protected String unableToInstantiate$str() {
        return unableToInstantiate;
    }
    @Override
    public final IllegalStateException unableToInstantiate(final Object param1, final Object param2, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToInstantiate$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void initSkippedNoBeanArchiveFound() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, initSkippedNoBeanArchiveFound$str());
    }
    private static final String initSkippedNoBeanArchiveFound = "WELD-ENV-000028: Weld initialization skipped - no bean archive found";
    protected String initSkippedNoBeanArchiveFound$str() {
        return initSkippedNoBeanArchiveFound;
    }
    private static final String cannotLoadClass = "WELD-ENV-000029: Cannot load class for {0}.";
    protected String cannotLoadClass$str() {
        return cannotLoadClass;
    }
    @Override
    public final IllegalStateException cannotLoadClass(final Object param1, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotLoadClass$str(), param1), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotLoadClassUsingResourceLoader(final String className) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, cannotLoadClassUsingResourceLoader$str(), className);
    }
    private static final String cannotLoadClassUsingResourceLoader = "WELD-ENV-000030: Cannot load class using the ResourceLoader: {0}";
    protected String cannotLoadClassUsingResourceLoader$str() {
        return cannotLoadClassUsingResourceLoader;
    }
    @Override
    public final void beanArchiveReferenceCannotBeHandled(final Object beanArchiveRef, final Object handlers) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, beanArchiveReferenceCannotBeHandled$str(), beanArchiveRef, handlers);
    }
    private static final String beanArchiveReferenceCannotBeHandled = "WELD-ENV-000031: The bean archive reference {0} cannot be handled by any BeanArchiveHandler: {1}";
    protected String beanArchiveReferenceCannotBeHandled$str() {
        return beanArchiveReferenceCannotBeHandled;
    }
    @Override
    public final void processingBeanArchiveReference(final Object beanArchiveRef) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, processingBeanArchiveReference$str(), beanArchiveRef);
    }
    private static final String processingBeanArchiveReference = "WELD-ENV-000032: Processing bean archive reference: {0}";
    protected String processingBeanArchiveReference$str() {
        return processingBeanArchiveReference;
    }
    private static final String invalidScanningResult = "WELD-ENV-000033: Invalid bean archive scanning result - found multiple results with the same reference: {0}";
    protected String invalidScanningResult$str() {
        return invalidScanningResult;
    }
    @Override
    public final IllegalStateException invalidScanningResult(final Object beanArchiveRef) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(invalidScanningResult$str(), beanArchiveRef));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotScanClassPathEntry = "WELD-ENV-000034: Cannot scan class path entry: {0}";
    protected String cannotScanClassPathEntry$str() {
        return cannotScanClassPathEntry;
    }
    @Override
    public final IllegalStateException cannotScanClassPathEntry(final Object entry, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotScanClassPathEntry$str(), entry), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadClassPathEntry = "WELD-ENV-000035: Class path entry does not exist or cannot be read: {0}";
    protected String cannotReadClassPathEntry$str() {
        return cannotReadClassPathEntry;
    }
    @Override
    public final IllegalStateException cannotReadClassPathEntry(final Object entry) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotReadClassPathEntry$str(), entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadJavaClassPathSystemProperty = "WELD-ENV-000036: Weld cannot read the java class path system property!";
    protected String cannotReadJavaClassPathSystemProperty$str() {
        return cannotReadJavaClassPathSystemProperty;
    }
    @Override
    public final IllegalStateException cannotReadJavaClassPathSystemProperty() {
        final IllegalStateException result = new IllegalStateException(cannotReadJavaClassPathSystemProperty$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInitializeProbeComponent = "WELD-ENV-000037: Unable to initialize the Probe component: {0}";
    protected String unableToInitializeProbeComponent$str() {
        return unableToInitializeProbeComponent;
    }
    @Override
    public final IllegalStateException unableToInitializeProbeComponent(final Object component, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToInitializeProbeComponent$str(), component), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String probeComponentNotFoundOnClasspath = "WELD-ENV-000038: Development mode is enabled but the following Probe component is not found on the classpath: {0}";
    protected String probeComponentNotFoundOnClasspath$str() {
        return probeComponentNotFoundOnClasspath;
    }
    @Override
    public final IllegalStateException probeComponentNotFoundOnClasspath(final Object component) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(probeComponentNotFoundOnClasspath$str(), component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void beanArchiveReferenceHandled(final Object beanArchiveRef, final Object handler) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, beanArchiveReferenceHandled$str(), beanArchiveRef, handler);
    }
    private static final String beanArchiveReferenceHandled = "WELD-ENV-000039: Bean archive reference {0} handled by {1}";
    protected String beanArchiveReferenceHandled$str() {
        return beanArchiveReferenceHandled;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
    @Override
    public final void catchingTrace(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, throwable, catchingTrace$str());
    }
    private static final String catchingTrace = "Catching";
    protected String catchingTrace$str() {
        return catchingTrace;
    }
}
