/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.RunWithinInterceptionDecorationContextGenerator;
import org.jboss.weld.bean.proxy.StackAwareMethodHandler;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptedSubclassFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "Subclass";
    private static final String SUPER_DELEGATE_SUFFIX = "$$super";
    private static final String COMBINED_INTERCEPTOR_AND_DECORATOR_STACK_METHOD_HANDLER_CLASS_NAME = CombinedInterceptorAndDecoratorStackMethodHandler.class.getName();
    private static final String[] INVOKE_METHOD_PARAMETERS = new String[]{DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class), "Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "Ljava/lang/reflect/Method;", "[Ljava/lang/Object;"};
    private final Set<MethodSignature> enhancedMethodSignatures;
    private final Set<MethodSignature> interceptedMethodSignatures;
    private final Class<?> proxiedBeanType;

    public InterceptedSubclassFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean, Set<MethodSignature> enhancedMethodSignatures, Set<MethodSignature> interceptedMethodSignatures) {
        this(contextId, proxiedBeanType, typeClosure, InterceptedSubclassFactory.getProxyName(contextId, proxiedBeanType, typeClosure, bean), bean, enhancedMethodSignatures, interceptedMethodSignatures);
    }

    public InterceptedSubclassFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean, Set<MethodSignature> enhancedMethodSignatures, Set<MethodSignature> interceptedMethodSignatures) {
        super(contextId, proxiedBeanType, typeClosure, proxyName, bean, true);
        this.enhancedMethodSignatures = enhancedMethodSignatures;
        this.interceptedMethodSignatures = interceptedMethodSignatures;
        this.proxiedBeanType = proxiedBeanType;
    }

    @Override
    public void addInterfacesFromTypeClosure(Set<? extends Type> typeClosure, Class<?> proxiedBeanType) {
        for (Class<?> c : proxiedBeanType.getInterfaces()) {
            this.addInterface(c);
        }
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    @Override
    protected void addMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        this.addMethodsFromClass(proxyClassType, staticConstructor);
        this.addSpecialMethods(proxyClassType, staticConstructor);
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            HashSet<MethodSignatureImpl> finalMethods = new HashSet<MethodSignatureImpl>();
            HashSet<BridgeMethod> processedBridgeMethods = new HashSet<BridgeMethod>();
            for (Class<?> cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                HashSet<BridgeMethod> declaredBridgeMethods = new HashSet<BridgeMethod>();
                for (Method method : AccessController.doPrivileged(new GetDeclaredMethodsAction(cls))) {
                    MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
                    if (!(Modifier.isFinal(method.getModifiers()) || method.isBridge() || !this.enhancedMethodSignatures.contains(methodSignature) || finalMethods.contains(methodSignature) || this.bridgeMethodsContainsMethod(processedBridgeMethods, methodSignature, method.getGenericReturnType()))) {
                        try {
                            ClassMethod classMethod;
                            final RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                            if (this.interceptedMethodSignatures.contains(methodSignature)) {
                                this.createDelegateMethod(proxyClassType, method, methodInfo);
                                classMethod = proxyClassType.addMethod(method);
                                this.addConstructedGuardToMethodBody(classMethod);
                                this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                                BeanLogger.LOG.addingMethodToProxy(method);
                                continue;
                            }
                            classMethod = proxyClassType.addMethod(method);
                            new RunWithinInterceptionDecorationContextGenerator(classMethod, this){

                                @Override
                                void doWork(CodeAttribute b, ClassMethod method) {
                                    b.aload(0);
                                    b.loadMethodParameters();
                                    b.invokespecial(methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getDescriptor());
                                }

                                @Override
                                void doReturn(CodeAttribute b, ClassMethod method) {
                                    b.returnInstruction();
                                }
                            }.runStartIfNotOnTop();
                        }
                        catch (DuplicateMemberException methodInfo) {}
                        continue;
                    }
                    if (Modifier.isFinal(method.getModifiers())) {
                        finalMethods.add(methodSignature);
                    }
                    if (!method.isBridge()) continue;
                    declaredBridgeMethods.add(new BridgeMethod(methodSignature, method.getGenericReturnType()));
                }
                processedBridgeMethods.addAll(declaredBridgeMethods);
            }
            for (Class<?> c : this.getAdditionalInterfaces()) {
                for (Method method : c.getMethods()) {
                    MethodSignatureImpl signature = new MethodSignatureImpl(method);
                    if (this.enhancedMethodSignatures.contains(signature) && !this.bridgeMethodsContainsMethod(processedBridgeMethods, signature, null)) {
                        try {
                            ClassMethod classMethod;
                            RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                            if (this.interceptedMethodSignatures.contains(signature) && Reflections.isDefault(method)) {
                                this.createDelegateMethod(proxyClassType, method, methodInfo);
                                classMethod = proxyClassType.addMethod(method);
                                this.addConstructedGuardToMethodBody(classMethod);
                                this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                                BeanLogger.LOG.addingMethodToProxy(method);
                            } else if (Reflections.isDefault(method)) {
                                this.createDelegateMethod(proxyClassType, method, methodInfo);
                            } else {
                                classMethod = proxyClassType.addMethod(method);
                                this.createSpecialMethodBody(classMethod, methodInfo, staticConstructor);
                                BeanLogger.LOG.addingMethodToProxy(method);
                            }
                        }
                        catch (DuplicateMemberException duplicateMemberException) {
                            // empty catch block
                        }
                    }
                    if (!method.isBridge()) continue;
                    processedBridgeMethods.add(new BridgeMethod(signature, method.getGenericReturnType()));
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private boolean bridgeMethodsContainsMethod(Set<BridgeMethod> processedBridgeMethods, MethodSignature signature, Type returnType) {
        for (BridgeMethod bridgeMethod : processedBridgeMethods) {
            if (!bridgeMethod.signature.equals(signature)) continue;
            if (returnType != null) {
                return bridgeMethod.returnType.equals(returnType);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void createForwardingMethodBody(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        this.createInterceptorBody(classMethod, method, true, staticConstructor);
    }

    protected void createInterceptorBody(ClassMethod method, MethodInformation methodInfo, boolean delegateToSuper, ClassMethod staticConstructor) {
        this.invokeMethodHandler(method, methodInfo, true, DEFAULT_METHOD_RESOLVER, delegateToSuper, staticConstructor);
    }

    private void createDelegateToSuper(ClassMethod classMethod, MethodInformation method) {
        this.createDelegateToSuper(classMethod, method, classMethod.getClassFile().getSuperclass());
    }

    private void createDelegateToSuper(ClassMethod classMethod, MethodInformation method, String className) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        b.loadMethodParameters();
        b.invokespecial(className, method.getName(), method.getDescriptor());
        b.returnInstruction();
    }

    protected void invokeMethodHandler(ClassMethod method, MethodInformation methodInfo, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver, boolean addProceed, ClassMethod staticConstructor) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(method.getClassFile(), b);
        if (addProceed) {
            b.dup();
            b.invokestatic(InterceptionDecorationContext.class.getName(), "getStack", "()" + DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class));
            if (!Reflections.isDefault(methodInfo.getMethod())) {
                b.dupX1();
                b.invokevirtual(COMBINED_INTERCEPTOR_AND_DECORATOR_STACK_METHOD_HANDLER_CLASS_NAME, "isDisabledHandler", "(" + DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class) + ")" + "Z");
                b.iconst(0);
                BranchEnd invokeSuperDirectly = b.ifIcmpeq();
                b.pop2();
                b.aload(0);
                b.loadMethodParameters();
                b.invokespecial(methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getDescriptor());
                b.returnInstruction();
                b.branchEnd(invokeSuperDirectly);
            }
        } else {
            b.aconstNull();
        }
        b.aload(0);
        bytecodeMethodResolver.getDeclaredMethod(method, methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getParameterTypes(), staticConstructor);
        if (addProceed) {
            if (Modifier.isPrivate(method.getAccessFlags())) {
                bytecodeMethodResolver.getDeclaredMethod(method, methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getParameterTypes(), staticConstructor);
            } else {
                bytecodeMethodResolver.getDeclaredMethod(method, method.getClassFile().getName(), methodInfo.getName() + SUPER_DELEGATE_SUFFIX, methodInfo.getParameterTypes(), staticConstructor);
            }
        } else {
            b.aconstNull();
        }
        b.iconst(methodInfo.getParameterTypes().length);
        b.anewarray("java.lang.Object");
        int localVariableCount = 1;
        for (int i = 0; i < methodInfo.getParameterTypes().length; ++i) {
            String typeString = methodInfo.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary(b, typeString);
            b.aastore();
            if (DescriptorUtils.isWide(typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(StackAwareMethodHandler.class.getName(), "invoke", "Ljava/lang/Object;", INVOKE_METHOD_PARAMETERS);
        if (addReturnInstruction) {
            if (methodInfo.getReturnType().equals("V")) {
                b.returnInstruction();
            } else if (DescriptorUtils.isPrimitive(methodInfo.getReturnType())) {
                Boxing.unbox(b, method.getReturnType());
                b.returnInstruction();
            } else {
                b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
                b.returnInstruction();
            }
        }
    }

    @Override
    protected void addSpecialMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            for (Method method : LifecycleMixin.class.getMethods()) {
                BeanLogger.LOG.addingMethodToProxy(method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                this.createInterceptorBody(proxyClassType.addMethod(method), methodInfo, false, staticConstructor);
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getMethod("getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getMethod("getTargetClass", new Class[0]);
            InterceptedSubclassFactory.generateGetTargetInstanceBody(proxyClassType.addMethod(getInstanceMethod));
            InterceptedSubclassFactory.generateGetTargetClassBody(proxyClassType.addMethod(getInstanceClassMethod));
            Method setMethodHandlerMethod = ProxyObject.class.getMethod("setHandler", MethodHandler.class);
            this.generateSetMethodHandlerBody(proxyClassType.addMethod(setMethodHandlerMethod));
            Method getMethodHandlerMethod = ProxyObject.class.getMethod("getHandler", new Class[0]);
            this.generateGetMethodHandlerBody(proxyClassType.addMethod(getMethodHandlerMethod));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private static void generateGetTargetInstanceBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        b.returnInstruction();
    }

    private static void generateGetTargetClassBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        BytecodeUtils.pushClassType(b, method.getClassFile().getSuperclass());
        b.returnInstruction();
    }

    @Override
    public Class<?> getBeanType() {
        return this.proxiedBeanType;
    }

    @Override
    protected Class<? extends MethodHandler> getMethodHandlerType() {
        return CombinedInterceptorAndDecoratorStackMethodHandler.class;
    }

    private void createDelegateMethod(ClassFile proxyClassType, Method method, MethodInformation methodInformation) {
        int modifiers = (method.getModifiers() | 0x1000 | 2) & 0xFFFFFFFE & 0xFFFFFFFB;
        ClassMethod delegatingMethod = proxyClassType.addMethod(modifiers, method.getName() + SUPER_DELEGATE_SUFFIX, DescriptorUtils.makeDescriptor(method.getReturnType()), DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        delegatingMethod.addCheckedExceptions(method.getExceptionTypes());
        this.createDelegateToSuper(delegatingMethod, methodInformation);
    }

    private static class BridgeMethod {
        private final Type returnType;
        private final MethodSignature signature;

        public BridgeMethod(MethodSignature signature, Type returnType) {
            this.signature = signature;
            this.returnType = returnType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BridgeMethod)) {
                return false;
            }
            BridgeMethod other = (BridgeMethod)obj;
            if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
                return false;
            }
            return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
        }

        public String toString() {
            return "method " + this.returnType + " " + this.signature.getMethodName() + Arrays.toString(this.signature.getParameterTypes()).replace('[', '(').replace(']', ')');
        }
    }
}

