/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.event.EventMetadataImpl;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.experimental.ExperimentalEvent;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.EventObjectTypeResolverBuilder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.TypeResolver;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"}, justification="Uses SerializationProxy")
public class EventImpl<T>
extends AbstractFacade<T, Event<T>>
implements ExperimentalEvent<T>,
Serializable {
    private static final String EVENT_ARGUMENT_NAME = "event";
    private static final String SUBTYPE_ARGUMENT_NAME = "subtype";
    private static final long serialVersionUID = 656782657242515455L;
    private static final int DEFAULT_CACHE_CAPACITY = 4;
    private final transient HierarchyDiscovery injectionPointTypeHierarchy = new HierarchyDiscovery(this.getType());
    private volatile transient CachedObservers lastCachedObservers;
    private final transient Map<Class<?>, CachedObservers> cachedObservers = new ConcurrentHashMap(4);

    public static <E> EventImpl<E> of(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        return new EventImpl(injectionPoint, beanManager);
    }

    private EventImpl(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        super(injectionPoint, null, beanManager);
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Event<" + Formats.formatType(this.getType()) + ">";
    }

    @Override
    public void fire(T event) {
        Preconditions.checkArgumentNotNull(event, EVENT_ARGUMENT_NAME);
        CachedObservers observers = this.getObservers(event);
        this.getBeanManager().getGlobalLenientObserverNotifier().notify(observers.observers, event, observers.syncMetadata);
    }

    @Override
    public <U extends T> CompletionStage<U> fireAsync(U event) {
        Preconditions.checkArgumentNotNull(event, EVENT_ARGUMENT_NAME);
        return this.fireAsyncInternal(event, null);
    }

    @Override
    public <U extends T> CompletionStage<U> fireAsync(U event, Executor executor) {
        Preconditions.checkArgumentNotNull(event, EVENT_ARGUMENT_NAME);
        Preconditions.checkArgumentNotNull(executor, "executor");
        return this.fireAsyncInternal(event, executor);
    }

    private <U extends T> CompletionStage<U> fireAsyncInternal(U event, Executor executor) {
        CachedObservers observers = this.getObservers(event);
        return this.getBeanManager().getGlobalLenientObserverNotifier().notifyAsync(observers.observers, event, observers.asyncMetadata, executor);
    }

    private CachedObservers getObservers(T event) {
        Class<?> runtimeType = event.getClass();
        CachedObservers lastResolvedObservers = this.lastCachedObservers;
        if (lastResolvedObservers != null && lastResolvedObservers.rawType.equals(runtimeType)) {
            return lastResolvedObservers;
        }
        lastResolvedObservers = this.cachedObservers.get(runtimeType);
        if (lastResolvedObservers == null) {
            lastResolvedObservers = WeldCollections.putIfAbsent(this.cachedObservers, runtimeType, this.createCachedObservers(runtimeType));
        }
        this.lastCachedObservers = lastResolvedObservers;
        return this.lastCachedObservers;
    }

    private CachedObservers createCachedObservers(Class<?> runtimeType) {
        Type eventType = this.getEventType(runtimeType);
        ResolvedObservers observers = this.getBeanManager().getGlobalStrictObserverNotifier().resolveObserverMethods(eventType, this.getQualifiers());
        EventMetadataImpl syncMetadata = new EventMetadataImpl(eventType, this.getInjectionPoint(), this.getQualifiers(), false);
        EventMetadataImpl asyncMetadata = new EventMetadataImpl(eventType, this.getInjectionPoint(), this.getQualifiers(), true);
        return new CachedObservers(runtimeType, observers, syncMetadata, asyncMetadata);
    }

    @Override
    public ExperimentalEvent<T> select(Annotation ... qualifiers) {
        return this.selectEvent(this.getType(), qualifiers);
    }

    @Override
    public <U extends T> ExperimentalEvent<U> select(Class<U> subtype, Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(subtype, SUBTYPE_ARGUMENT_NAME);
        return this.selectEvent(subtype, qualifiers);
    }

    @Override
    public <U extends T> ExperimentalEvent<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(subtype, SUBTYPE_ARGUMENT_NAME);
        return this.selectEvent(subtype.getType(), qualifiers);
    }

    private <U extends T> ExperimentalEvent<U> selectEvent(Type subtype, Annotation[] newQualifiers) {
        this.getBeanManager().getGlobalStrictObserverNotifier().checkEventObjectType(subtype);
        return new EventImpl<T>(new FacadeInjectionPoint(this.getBeanManager(), this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers), this.getBeanManager());
    }

    protected Type getEventType(Class<?> runtimeType) {
        Type resolvedType = runtimeType;
        if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
            resolvedType = this.injectionPointTypeHierarchy.resolveType(resolvedType);
        }
        if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
            Type canonicalEventType = Types.getCanonicalType(runtimeType);
            TypeResolver objectTypeResolver = new EventObjectTypeResolverBuilder(this.injectionPointTypeHierarchy.getResolver().getResolvedTypeVariables(), new HierarchyDiscovery(canonicalEventType).getResolver().getResolvedTypeVariables()).build();
            resolvedType = objectTypeResolver.resolveType(canonicalEventType);
        }
        return resolvedType;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw EventLogger.LOG.proxyRequired();
    }

    private class CachedObservers {
        private final Class<?> rawType;
        private final ResolvedObservers<T> observers;
        private final EventMetadata syncMetadata;
        private final EventMetadata asyncMetadata;

        private CachedObservers(Class<?> rawType, ResolvedObservers<T> observers, EventMetadata syncMetadata, EventMetadata asyncMetadata) {
            this.rawType = rawType;
            this.observers = observers;
            this.syncMetadata = syncMetadata;
            this.asyncMetadata = asyncMetadata;
        }
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Event<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(EventImpl<T> event) {
            super(event);
        }

        private Object readResolve() throws ObjectStreamException {
            return EventImpl.of(this.getInjectionPoint(), this.getBeanManager());
        }
    }
}

