/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.event.FireAsyncException;
import org.jboss.weld.util.ForwardingCompletionStage;

public class AsyncEventDeliveryStage<T>
extends ForwardingCompletionStage<T> {
    private final CompletionStage<T> delegate;

    static <T> AsyncEventDeliveryStage<T> completed(T event) {
        CompletableFuture<T> delegate = new CompletableFuture<T>();
        delegate.complete(event);
        return new AsyncEventDeliveryStage(delegate);
    }

    AsyncEventDeliveryStage(Supplier<T> supplier, Executor executor) {
        this(CompletableFuture.supplyAsync(supplier, executor));
    }

    private AsyncEventDeliveryStage(CompletionStage<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected CompletionStage<T> delegate() {
        return this.delegate;
    }

    @Override
    public CompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenComplete((r, t) -> action.accept(r, AsyncEventDeliveryStage.unwrap(t)));
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenCompleteAsync((r, t) -> action.accept(r, AsyncEventDeliveryStage.unwrap(t)));
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return super.whenCompleteAsync((r, t) -> action.accept(r, AsyncEventDeliveryStage.unwrap(t)), executor);
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handle((r, t) -> fn.apply(r, AsyncEventDeliveryStage.unwrap(t)));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handleAsync((r, t) -> fn.apply(r, AsyncEventDeliveryStage.unwrap(t)));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return super.handleAsync((r, t) -> fn.apply(r, AsyncEventDeliveryStage.unwrap(t)), executor);
    }

    @Override
    public CompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return super.exceptionally(t -> fn.apply(AsyncEventDeliveryStage.unwrap(t)));
    }

    private static Throwable unwrap(Throwable exception) {
        if (exception != null) {
            if (exception instanceof CompletionException) {
                exception = ((CompletionException)exception).getCause();
            }
            if (!(exception instanceof FireAsyncException)) {
                exception = new FireAsyncException(exception);
            }
        }
        return exception;
    }
}

