/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.collections.ListToSet;
import org.jboss.weld.util.reflection.Reflections;

abstract class AbstractCallableInjectionPoint<T, X, S extends Member>
implements WeldInjectionPointAttributes<T, S> {
    private final Bean<?> declaringBean;
    private final List<ParameterInjectionPoint<?, X>> parameters;
    private final Set<InjectionPoint> injectionPoints;
    protected final boolean hasTransientReferenceParameter;

    protected AbstractCallableInjectionPoint(EnhancedAnnotatedCallable<T, X, S> callable, Bean<?> declaringBean, Class<?> declaringComponentClass, boolean observerOrDisposer, InjectionPointFactory factory, BeanManagerImpl manager) {
        this.declaringBean = declaringBean;
        this.parameters = factory.getParameterInjectionPoints(callable, declaringBean, declaringComponentClass, manager, observerOrDisposer);
        this.injectionPoints = observerOrDisposer ? InjectionPoints.filterOutSpecialParameterInjectionPoints(this.parameters) : new ListToSet<InjectionPoint>(){

            @Override
            protected List<InjectionPoint> delegate() {
                return (List)Reflections.cast(AbstractCallableInjectionPoint.this.getParameterInjectionPoints());
            }
        };
        this.hasTransientReferenceParameter = AbstractCallableInjectionPoint.initHasTransientReference(callable.getEnhancedParameters());
    }

    private static boolean initHasTransientReference(List<? extends EnhancedAnnotatedParameter<?, ?>> parameters) {
        for (EnhancedAnnotatedParameter<?, ?> parameter : parameters) {
            if (!parameter.isAnnotationPresent(TransientReference.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Type getType() {
        return this.getAnnotated().getBaseType();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public <A extends Annotation> A getQualifier(Class<A> annotationType) {
        A qualifier = this.getAnnotated().getAnnotation(annotationType);
        if (this.getQualifiers().contains(qualifier)) {
            return qualifier;
        }
        return null;
    }

    @Override
    public Member getMember() {
        return this.getAnnotated().getJavaMember();
    }

    @Override
    public abstract AnnotatedCallable<X> getAnnotated();

    public List<ParameterInjectionPoint<?, X>> getParameterInjectionPoints() {
        return this.parameters;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractCallableInjectionPoint) {
            AbstractCallableInjectionPoint ip = (AbstractCallableInjectionPoint)obj;
            if (AnnotatedTypes.compareAnnotatedCallable(this.getAnnotated(), ip.getAnnotated())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getAnnotated().hashCode();
    }

    public String toString() {
        return this.getAnnotated().toString();
    }
}

