/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.annotated;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.util.annotated.ForwardingAnnotatedType;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class AnnotatedTypeWrapper<T>
extends ForwardingAnnotatedType<T> {
    private final AnnotatedType<T> delegate;
    private final Set<Annotation> annotations;

    public AnnotatedTypeWrapper(AnnotatedType<T> delegate, Annotation ... additionalAnnotations) {
        this(delegate, true, additionalAnnotations);
    }

    public AnnotatedTypeWrapper(AnnotatedType<T> delegate, boolean keepOriginalAnnotations, Annotation ... additionalAnnotations) {
        this.delegate = delegate;
        ImmutableSet.Builder<Annotation> builder = ImmutableSet.builder();
        if (keepOriginalAnnotations) {
            builder.addAll((Iterable<Annotation>)delegate.getAnnotations());
        }
        for (Annotation annotation : additionalAnnotations) {
            builder.add(annotation);
        }
        this.annotations = builder.build();
    }

    @Override
    public AnnotatedType<T> delegate() {
        return this.delegate;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (A)((Annotation)Reflections.cast(annotation));
        }
        return null;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation((Class)annotationType) != null;
    }
}

